/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.rdf.model.Model;
import java.net.URI;
import java.net.URISyntaxException;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;

public final class IOUtils {
    private IOUtils() {
    }

    public static Model getModelFromQueryFactory(QueryExecutionFactory qef) throws Exception {
        if (qef instanceof QueryExecutionFactoryModel) {
            return ((QueryExecutionFactoryModel)qef).getModel();
        }
        try (QueryExecution qe = null;){
            qe = qef.createQueryExecution(" CONSTRUCT ?s ?p ?o WHERE { ?s ?p ?o } ");
            Model model = qe.execConstruct();
            return model;
        }
    }

    public static boolean isURI(String uri) {
        try {
            new URI(uri);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

