/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.utils;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.services.PatternService;
import org.aksw.rdfunit.services.PrefixNSService;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.tests.TestAutoGenerator;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.results.ResultAnnotation;
import org.aksw.rdfunit.utils.SparqlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestGeneratorUtils {
    private static final Logger log = LoggerFactory.getLogger(TestGeneratorUtils.class);

    private TestGeneratorUtils() {
    }

    public static Collection<TestAutoGenerator> instantiateTestGeneratorsFromModel(QueryExecutionFactory queryFactory) {
        ArrayList<TestAutoGenerator> autoGenerators = new ArrayList<TestAutoGenerator>();
        String sparqlSelect = PrefixNSService.getSparqlPrefixDecl() + " SELECT ?generator ?desc ?query ?patternID WHERE { " + " ?generator " + "    a rut:TestGenerator ; " + "    dcterms:description ?desc ; " + "    rut:sparqlGenerator ?query ; " + "    rut:basedOnPattern ?pattern . " + " ?pattern dcterms:identifier ?patternID ." + "} ";
        QueryExecution qe = queryFactory.createQueryExecution(sparqlSelect);
        ResultSet results = qe.execSelect();
        while (results.hasNext()) {
            QuerySolution qs = results.next();
            String generator = qs.get("generator").toString();
            String description = qs.get("desc").toString();
            String query = qs.get("query").toString();
            String patternID = qs.get("patternID").toString();
            Collection<ResultAnnotation> annotations = SparqlUtils.getResultAnnotations(queryFactory, generator);
            TestAutoGenerator tag = new TestAutoGenerator(generator, description, query, PatternService.getPattern(patternID), annotations);
            if (tag.isValid()) {
                autoGenerators.add(tag);
                continue;
            }
            log.error("AutoGenerator not valid: " + tag.getUri());
            System.exit(-1);
        }
        qe.close();
        return autoGenerators;
    }

    public static Collection<TestCase> instantiateTestsFromAG(Collection<TestAutoGenerator> autoGenerators, SchemaSource source) {
        ArrayList<TestCase> tests = new ArrayList<TestCase>();
        for (TestAutoGenerator tag : autoGenerators) {
            tests.addAll(tag.generate(source));
        }
        return tests;
    }
}

