/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.utils;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.rdfunit.utils.LOVEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LOVUtils {
    private static final Logger log = LoggerFactory.getLogger(LOVUtils.class);
    private static final String lovEndpointURI = "http://lov.okfn.org/dataset/lov/sparql";
    private static final String lovGraph = "http://lov.okfn.org/dataset/lov";
    private static final String lovSparqlQuery = "PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>\nPREFIX vann:<http://purl.org/vocab/vann/>\nPREFIX voaf:<http://purl.org/vocommons/voaf#>\nSELECT ?vocabURI ?vocabPrefix ?vocabNamespace ?definedBy\nWHERE{\n\t?vocabURI a voaf:Vocabulary.\n\t?vocabURI vann:preferredNamespacePrefix ?vocabPrefix.\n\t?vocabURI vann:preferredNamespaceUri ?vocabNamespace.\n\tOPTIONAL {?vocabURI rdfs:isDefinedBy ?definedBy.}\n} \nORDER BY ?vocabPrefix ";

    private LOVUtils() {
    }

    public static List<LOVEntry> getAllLOVEntries() {
        LinkedList<LOVEntry> lovEntries = new LinkedList<LOVEntry>();
        QueryExecutionFactoryHttp qef = new QueryExecutionFactoryHttp(LOVUtils.getLovEndpointURI(), Arrays.asList(LOVUtils.getLovGraph()));
        try (QueryExecution qe = qef.createQueryExecution(LOVUtils.getLOVSparqlQuery());){
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                String ns;
                QuerySolution row = rs.next();
                String prefix = row.get("vocabPrefix").toString();
                String vocab = row.get("vocabURI").toString();
                String definedBy = ns = row.get("vocabNamespace").toString();
                if (ns == null || ns.isEmpty()) {
                    ns = vocab;
                }
                if (row.get("definedBy") != null) {
                    definedBy = row.get("definedBy").toString();
                }
                lovEntries.add(new LOVEntry(prefix, vocab, ns, definedBy));
            }
        }
        catch (Exception e) {
            log.error("Encountered error when reading schema information from LOV, schema prefixes & auto schema discovery might not work as expected", (Throwable)e);
        }
        return lovEntries;
    }

    public static String getLOVSparqlQuery() {
        return lovSparqlQuery;
    }

    public static String getLovEndpointURI() {
        return lovEndpointURI;
    }

    public static String getLovGraph() {
        return lovGraph;
    }
}

