/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.results;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import org.aksw.rdfunit.enums.RLOGLevel;
import org.aksw.rdfunit.services.PrefixNSService;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.results.TestCaseResult;

public class RLOGTestCaseResult
extends TestCaseResult {
    private final String resource;
    private final String message;
    private final RLOGLevel logLevel;

    public RLOGTestCaseResult(TestCase testCase, String resource, String message, RLOGLevel logLevel) {
        super(testCase);
        this.resource = resource;
        this.message = message;
        this.logLevel = logLevel;
    }

    @Override
    public Resource serialize(Model model, String testExecutionURI) {
        return super.serialize(model, testExecutionURI).addProperty(RDF.type, (RDFNode)model.createResource(PrefixNSService.getURIFromAbbrev("rut:RLOGTestCaseResult"))).addProperty(RDF.type, (RDFNode)model.createResource(PrefixNSService.getURIFromAbbrev("rlog:Entry"))).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev("rlog:resource")), (RDFNode)model.createResource(this.getResource())).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev("rlog:message")), this.getMessage()).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev("rlog:level")), (RDFNode)model.createResource(this.getLogLevel().getUri()));
    }

    public String getResource() {
        return this.resource;
    }

    public String getMessage() {
        return this.message;
    }

    public RLOGLevel getLogLevel() {
        return this.logLevel;
    }
}

