/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.executors;

import java.util.ArrayList;
import java.util.Collection;
import org.aksw.rdfunit.enums.TestCaseResultStatus;
import org.aksw.rdfunit.exceptions.TestCaseExecutionException;
import org.aksw.rdfunit.sources.TestSource;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.TestSuite;
import org.aksw.rdfunit.tests.executors.monitors.TestExecutorMonitor;
import org.aksw.rdfunit.tests.query_generation.QueryGenerationFactory;
import org.aksw.rdfunit.tests.results.RLOGTestCaseResult;
import org.aksw.rdfunit.tests.results.StatusTestCaseResult;
import org.aksw.rdfunit.tests.results.TestCaseResult;
import org.aksw.rdfunit.utils.RDFUnitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestExecutor {
    private static final Logger log = LoggerFactory.getLogger(TestExecutor.class);
    private volatile boolean isCanceled = false;
    private final Collection<TestExecutorMonitor> progressMonitors = new ArrayList<TestExecutorMonitor>();
    protected final QueryGenerationFactory queryGenerationFactory;

    public TestExecutor(QueryGenerationFactory queryGenerationFactory) {
        this.queryGenerationFactory = queryGenerationFactory;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    protected abstract Collection<TestCaseResult> executeSingleTest(TestSource var1, TestCase var2) throws TestCaseExecutionException;

    public boolean execute(TestSource testSource, TestSuite testSuite) {
        boolean success = true;
        this.isCanceled = false;
        for (TestExecutorMonitor monitor : this.progressMonitors) {
            monitor.testingStarted(testSource, testSuite);
        }
        for (TestCase testCase : testSuite.getTestCases()) {
            TestCaseResultStatus status;
            if (this.isCanceled) break;
            for (TestExecutorMonitor monitor : this.progressMonitors) {
                monitor.singleTestStarted(testCase);
            }
            Collection<Object> results = new ArrayList();
            long executionTimeStartInMS = System.currentTimeMillis();
            log.debug("{} : started execution", (Object)testCase.getAbrTestURI());
            try {
                results = this.executeSingleTest(testSource, testCase);
            }
            catch (TestCaseExecutionException e) {
                status = e.getStatus();
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Unknown error while executing TC: " + testCase.getAbrTestURI(), e);
            }
            catch (Exception e) {
                log.error("Unknown error while executing TC: " + testCase.getAbrTestURI(), (Throwable)e);
                status = TestCaseResultStatus.Error;
            }
            long executionTimeEndInMS = System.currentTimeMillis();
            log.debug("{} : execution completed in {}ms", (Object)testCase.getAbrTestURI(), (Object)(executionTimeEndInMS - executionTimeStartInMS));
            if (results.isEmpty()) {
                status = TestCaseResultStatus.Success;
            } else if (results.size() > 1) {
                status = TestCaseResultStatus.Fail;
            } else {
                status = TestCaseResultStatus.Error;
                TestCaseResult r = (TestCaseResult)RDFUnitUtils.getFirstItemInCollection(results);
                if (r instanceof StatusTestCaseResult) {
                    status = ((StatusTestCaseResult)r).getStatus();
                } else if (r instanceof RLOGTestCaseResult) {
                    status = TestCaseResultStatus.Fail;
                }
            }
            if (status != TestCaseResultStatus.Success) {
                success = false;
            }
            for (TestExecutorMonitor monitor : this.progressMonitors) {
                monitor.singleTestExecuted(testCase, status, results);
            }
        }
        for (TestExecutorMonitor monitor : this.progressMonitors) {
            monitor.testingFinished();
        }
        return success;
    }

    public void addTestExecutorMonitor(TestExecutorMonitor monitor) {
        if (!this.progressMonitors.contains(monitor)) {
            this.progressMonitors.add(monitor);
        }
    }

    public void removeTestExecutorMonitor(TestExecutorMonitor monitor) {
        this.progressMonitors.remove(monitor);
    }

    public void clearTestExecutorMonitor() {
        this.progressMonitors.clear();
    }
}

