/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.executors;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.aksw.rdfunit.enums.RLOGLevel;
import org.aksw.rdfunit.exceptions.TestCaseExecutionException;
import org.aksw.rdfunit.sources.TestSource;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.executors.RLOGTestExecutor;
import org.aksw.rdfunit.tests.query_generation.QueryGenerationFactory;
import org.aksw.rdfunit.tests.results.ExtendedTestCaseResult;
import org.aksw.rdfunit.tests.results.ResultAnnotation;
import org.aksw.rdfunit.tests.results.TestCaseResult;
import org.aksw.rdfunit.utils.StringUtils;

public class ExtendedTestExecutor
extends RLOGTestExecutor {
    public ExtendedTestExecutor(QueryGenerationFactory queryGenerationFactory) {
        super(queryGenerationFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<TestCaseResult> executeSingleTest(TestSource testSource, TestCase testCase) throws TestCaseExecutionException {
        ArrayList<TestCaseResult> testCaseResults = new ArrayList<TestCaseResult>();
        try (QueryExecution qe = null;){
            qe = testSource.getExecutionFactory().createQueryExecution(this.queryGenerationFactory.getSparqlQuery(testCase));
            ResultSet results = qe.execSelect();
            ExtendedTestCaseResult result = null;
            String prevResource = "";
            while (results.hasNext()) {
                QuerySolution qs = results.next();
                String resource = qs.get("resource").toString();
                if (qs.get("resource").isLiteral()) {
                    resource = StringUtils.getHashFromString(resource);
                }
                String message = testCase.getResultMessage();
                if (qs.contains("message")) {
                    message = qs.get("message").toString();
                }
                RLOGLevel logLevel = testCase.getLogLevel();
                if (!prevResource.equals(resource)) {
                    if (result != null) {
                        testCaseResults.add(result);
                    }
                    result = new ExtendedTestCaseResult(testCase, resource, message, logLevel);
                }
                assert (result != null);
                for (Map.Entry<ResultAnnotation, Set<RDFNode>> vaEntry : result.getVariableAnnotationsMap().entrySet()) {
                    String variable = vaEntry.getKey().getAnnotationValue().toString().trim().replace("?", "");
                    if (!qs.contains(variable)) continue;
                    vaEntry.getValue().add(qs.get(variable));
                }
            }
            if (result != null) {
                testCaseResults.add(result);
            }
        }
        return testCaseResults;
    }
}

