/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Collection;
import org.aksw.rdfunit.enums.RLOGLevel;
import org.aksw.rdfunit.exceptions.TestCaseInstantiationException;
import org.aksw.rdfunit.services.PrefixNSService;
import org.aksw.rdfunit.tests.TestCaseAnnotation;
import org.aksw.rdfunit.tests.results.ResultAnnotation;

public abstract class TestCase
implements Comparable<TestCase> {
    private final String testURI;
    private final TestCaseAnnotation annotation;

    public TestCase(String testURI, TestCaseAnnotation annotation) throws TestCaseInstantiationException {
        this.testURI = testURI;
        this.annotation = annotation;
    }

    public Model getUnitTestModel() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)ModelFactory.createDefaultModel());
        this.serialize((Model)model);
        return model;
    }

    public abstract String getSparqlWhere();

    public abstract String getSparqlPrevalence();

    public Resource serialize(Model model) {
        Resource resource = model.createResource(this.testURI);
        this.annotation.serialize(resource, model);
        return resource;
    }

    public String getResultMessage() {
        return this.annotation.getDescription();
    }

    public RLOGLevel getLogLevel() {
        return this.annotation.getTestCaseLogLevel();
    }

    public Collection<ResultAnnotation> getResultAnnotations() {
        return this.annotation.getResultAnnotations();
    }

    public Collection<ResultAnnotation> getVariableAnnotations() {
        return this.annotation.getVariableAnnotations();
    }

    public Query getSparqlPrevalenceQuery() {
        if (this.getSparqlPrevalence().trim().isEmpty()) {
            return null;
        }
        return QueryFactory.create((String)(PrefixNSService.getSparqlPrefixDecl() + this.getSparqlPrevalence()));
    }

    public String getTestURI() {
        return this.testURI;
    }

    public String getAbrTestURI() {
        return this.testURI.replace(PrefixNSService.getNSFromPrefix("rutt"), "rutt:");
    }

    @Override
    public int compareTo(TestCase o) {
        if (o == null) {
            return -1;
        }
        return this.getTestURI().compareTo(o.getTestURI());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestCase)) {
            return false;
        }
        TestCase testCase = (TestCase)o;
        return this.testURI.equals(testCase.testURI);
    }

    public int hashCode() {
        return this.testURI.hashCode();
    }

    public String toString() {
        return this.getTestURI();
    }
}

