/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Collection;
import org.aksw.rdfunit.exceptions.TestCaseInstantiationException;
import org.aksw.rdfunit.patterns.Pattern;
import org.aksw.rdfunit.services.PrefixNSService;
import org.aksw.rdfunit.tests.Binding;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.TestCaseAnnotation;
import org.aksw.rdfunit.tests.query_generation.QueryGenerationSelectFactory;

public class PatternBasedTestCase
extends TestCase {
    private final Pattern pattern;
    private final Collection<Binding> bindings;
    private String sparqlWhereCache = null;
    private String sparqlPrevalenceCache = null;

    public PatternBasedTestCase(String testURI, TestCaseAnnotation annotation, Pattern pattern, Collection<Binding> bindings) throws TestCaseInstantiationException {
        super(testURI, annotation);
        this.pattern = pattern;
        this.bindings = bindings;
        if (bindings.size() != pattern.getParameters().size()) {
            throw new TestCaseInstantiationException("Non valid bindings in TestCase: " + testURI);
        }
    }

    @Override
    public Resource serialize(Model model) {
        Resource resource = super.serialize(model);
        resource.addProperty(RDF.type, (RDFNode)model.createResource(PrefixNSService.getURIFromAbbrev("rut:PatternBasedTestCase"))).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev("rut:basedOnPattern")), (RDFNode)model.createResource(PrefixNSService.getURIFromAbbrev("rutp:" + this.pattern.getId()))).addProperty(RDFS.comment, "FOR DEBUGGING ONLY: SPARQL Query: \n" + new QueryGenerationSelectFactory().getSparqlQueryAsString(this) + "\n Prevalence SPARQL Query :\n" + this.getSparqlPrevalence());
        for (Binding binding : this.bindings) {
            resource.addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev("rut:binding")), (RDFNode)binding.writeToModel(model));
        }
        return resource;
    }

    @Override
    public String getSparqlWhere() {
        if (this.sparqlWhereCache == null) {
            this.sparqlWhereCache = this.instantiateBindings(this.bindings, this.pattern.getSparqlWherePattern()).trim();
        }
        return this.sparqlWhereCache;
    }

    @Override
    public String getSparqlPrevalence() {
        if (this.sparqlPrevalenceCache == null) {
            this.sparqlPrevalenceCache = this.instantiateBindings(this.bindings, this.pattern.getSparqlPatternPrevalence()).trim();
        }
        return this.sparqlPrevalenceCache;
    }

    private String instantiateBindings(Collection<Binding> bindings, String query) {
        String sparql = query;
        for (Binding b : bindings) {
            sparql = sparql.replace("%%" + b.getParameterId() + "%%", b.getValueAsString());
        }
        return sparql;
    }
}

