/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.statistics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.services.SchemaService;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.SchemaSourceFactory;
import org.aksw.rdfunit.statistics.DatasetStatistics;
import org.aksw.rdfunit.statistics.DatasetStatisticsAllIris;
import org.aksw.rdfunit.statistics.DatasetStatisticsClasses;
import org.aksw.rdfunit.statistics.DatasetStatisticsProperties;
import org.aksw.rdfunit.utils.CacheUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamespaceStatistics {
    private static final Logger log = LoggerFactory.getLogger(NamespaceStatistics.class);
    private final boolean skipUnknownNamespaces;
    private final Collection<String> excludePrefixes = Arrays.asList("rdf", "rdfs", "owl", "rdfa");
    private final Collection<DatasetStatistics> datasetStatistics;

    private NamespaceStatistics(Collection<DatasetStatistics> datasetStatisticses, boolean skipUnknownNamespaces) {
        this.datasetStatistics = Collections.unmodifiableCollection(datasetStatisticses);
        this.skipUnknownNamespaces = skipUnknownNamespaces;
    }

    public static NamespaceStatistics createOntologyNSStatisticsKnown() {
        List<DatasetStatistics> datasetStatistics = Arrays.asList(new DatasetStatisticsClasses(), new DatasetStatisticsProperties());
        return new NamespaceStatistics(datasetStatistics, true);
    }

    public static NamespaceStatistics createOntologyNSStatisticsAll() {
        List<DatasetStatistics> datasetStatistics = Arrays.asList(new DatasetStatisticsClasses(), new DatasetStatisticsProperties());
        return new NamespaceStatistics(datasetStatistics, false);
    }

    public static NamespaceStatistics createCompleteNSStatisticsKnown() {
        ArrayList<DatasetStatistics> datasetStatistics = new ArrayList<DatasetStatistics>();
        datasetStatistics.add(new DatasetStatisticsAllIris());
        return new NamespaceStatistics(datasetStatistics, true);
    }

    public static NamespaceStatistics createCompleteNSStatisticsAll() {
        ArrayList<DatasetStatistics> datasetStatistics = new ArrayList<DatasetStatistics>();
        datasetStatistics.add(new DatasetStatisticsAllIris());
        return new NamespaceStatistics(datasetStatistics, false);
    }

    public Collection<SchemaSource> getNamespaces(QueryExecutionFactory qef) {
        HashSet<String> namespaces = new HashSet<String>();
        for (DatasetStatistics dt : this.datasetStatistics) {
            for (String n : dt.getStatisticsMap(qef).keySet()) {
                namespaces.add(this.getNamespaceFromURI(n));
            }
        }
        return this.getIdentifiedSchemata(namespaces);
    }

    private Collection<SchemaSource> getIdentifiedSchemata(Collection<String> namespaces) {
        ArrayList<SchemaSource> sources = new ArrayList<SchemaSource>();
        for (String namespace : namespaces) {
            SchemaSource source = SchemaService.getSourceFromUri(namespace);
            if (source != null) {
                if (this.excludePrefixes.contains(source.getPrefix())) continue;
                sources.add(source);
                continue;
            }
            if (this.skipUnknownNamespaces) {
                log.warn("Undefined namespace in LOV or schemaDecl.csv: " + namespace);
                continue;
            }
            sources.add(SchemaSourceFactory.createSchemaSourceDereference(CacheUtils.getAutoPrefixForURI(namespace), namespace));
        }
        return sources;
    }

    public String getNamespaceFromURI(String uri) {
        String breakChar = "/";
        if (uri.contains("#")) {
            breakChar = "#";
        }
        int pos = Math.min(uri.lastIndexOf(breakChar), uri.length());
        return uri.substring(0, pos + 1);
    }
}

