/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.statistics;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.util.HashMap;
import java.util.Map;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatasetStatistics {
    private static final Logger log = LoggerFactory.getLogger(DatasetStatistics.class);

    protected abstract String getStatisticsQuery();

    public Map<String, Integer> getStatisticsMap(QueryExecutionFactory qef) {
        return this.getStats(this.getStatisticsQuery(), qef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Integer> getStats(String sparqlQuery, QueryExecutionFactory qef) {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        try (QueryExecution qe = null;){
            qe = qef.createQueryExecution(sparqlQuery);
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.next();
                String s = qs.get("stats").toString();
                int c = 0;
                if (qs.contains("count")) {
                    c = qs.get("count").asLiteral().getInt();
                }
                stats.put(s, c);
            }
        }
        return stats;
    }
}

