/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.util.Arrays;
import java.util.Collection;
import org.aksw.rdfunit.exceptions.UndefinedSerializationException;
import org.aksw.rdfunit.io.format.FormatService;
import org.aksw.rdfunit.io.format.SerializationFormat;
import org.aksw.rdfunit.io.format.SerializationFormatGraphType;
import org.aksw.rdfunit.io.reader.RDFReader;
import org.aksw.rdfunit.io.reader.RDFReaderFactory;
import org.aksw.rdfunit.io.reader.RDFStreamReader;
import org.aksw.rdfunit.sources.DatasetTestSource;
import org.aksw.rdfunit.sources.DumpTestSource;
import org.aksw.rdfunit.sources.EndpointTestSource;
import org.aksw.rdfunit.sources.QueryingConfig;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.SourceConfig;
import org.aksw.rdfunit.sources.TestSource;

public class TestSourceBuilder {
    private TestSourceType testSourceType = TestSourceType.InMemSingle;
    private SourceConfig sourceConfig = null;
    private Collection<SchemaSource> referenceSchemata = null;
    private QueryingConfig queryingConfig = null;
    private RDFReader inMemReader = null;
    private String sparqlEndpoint = null;
    private Collection<String> endpointGraphs = null;

    public TestSourceBuilder setPrefixUri(String prefix, String uri) {
        this.sourceConfig = new SourceConfig(prefix, uri);
        return this;
    }

    public TestSourceBuilder setEndpoint(String sparqlEndpoint, Collection<String> endpointGraphs) {
        this.testSourceType = TestSourceType.Endpoint;
        this.sparqlEndpoint = sparqlEndpoint;
        this.endpointGraphs = endpointGraphs;
        if (this.queryingConfig == null) {
            this.queryingConfig = QueryingConfig.createEndpoint();
        }
        return this;
    }

    public TestSourceBuilder setImMemSingle() {
        this.testSourceType = TestSourceType.InMemSingle;
        if (this.queryingConfig == null) {
            this.queryingConfig = QueryingConfig.createInMemory();
        }
        return this;
    }

    public TestSourceBuilder setImMemDataset() {
        this.testSourceType = TestSourceType.InMemDataset;
        if (this.queryingConfig == null) {
            this.queryingConfig = QueryingConfig.createInMemory();
        }
        return this;
    }

    public TestSourceBuilder setImMemFromUri(String uri) {
        SerializationFormat format = FormatService.getInputFormat(FormatService.getFormatFromExtension(uri));
        if (format != null && format.getGraphType().equals((Object)SerializationFormatGraphType.dataset)) {
            this.setImMemDataset();
        } else {
            this.setImMemSingle();
        }
        this.inMemReader = RDFReaderFactory.createDereferenceReader(uri);
        return this;
    }

    public TestSourceBuilder setInMemReader(RDFReader reader) {
        this.inMemReader = reader;
        if (this.queryingConfig == null) {
            this.queryingConfig = QueryingConfig.createInMemory();
        }
        return this;
    }

    public TestSourceBuilder setInMemFromPipe() {
        this.inMemReader = new RDFStreamReader(new BufferedInputStream(System.in), "TURTLE");
        this.setImMemSingle();
        return this;
    }

    public TestSourceBuilder setInMemFromCustomText(String customTextSource, String customTextFormat) throws UndefinedSerializationException {
        SerializationFormat format = FormatService.getInputFormat(customTextFormat);
        if (format == null) {
            throw new UndefinedSerializationException(customTextFormat);
        }
        this.inMemReader = RDFReaderFactory.createReaderFromText(customTextSource, format.getName());
        return this;
    }

    public TestSourceBuilder setReferenceSchemata(Collection<SchemaSource> referenceSchemata) {
        this.referenceSchemata = referenceSchemata;
        return this;
    }

    public TestSourceBuilder setReferenceSchemata(SchemaSource referenceSchema) {
        this.referenceSchemata = Arrays.asList(referenceSchema);
        return this;
    }

    public TestSourceBuilder setCacheTTL(long cacheTTL) {
        this.queryingConfig = this.queryingConfig.copyWithNewCacheTTL(cacheTTL);
        return this;
    }

    public TestSourceBuilder setQueryLimit(long queryLimit) {
        this.queryingConfig = this.queryingConfig.copyWithNewQueryLimit(queryLimit);
        return this;
    }

    public TestSourceBuilder setQueryDelay(long queryDelay) {
        this.queryingConfig = this.queryingConfig.copyWithNewQueryDelay(queryDelay);
        return this;
    }

    public TestSourceBuilder setPagination(long pagination) {
        this.queryingConfig = this.queryingConfig.copyWithNewPagination(pagination);
        return this;
    }

    public TestSource build() {
        Preconditions.checkNotNull((Object)this.sourceConfig);
        Preconditions.checkNotNull(this.referenceSchemata, (Object)"Referenced schemata not set in TestSourceBuilder");
        if (this.testSourceType.equals((Object)TestSourceType.Endpoint)) {
            if (this.queryingConfig == null) {
                this.queryingConfig = QueryingConfig.createEndpoint();
            }
            Preconditions.checkNotNull((Object)this.sparqlEndpoint);
            Preconditions.checkNotNull(this.endpointGraphs);
            return new EndpointTestSource(this.sourceConfig, this.queryingConfig, this.referenceSchemata, this.sparqlEndpoint, this.endpointGraphs);
        }
        if (this.queryingConfig == null) {
            this.queryingConfig = QueryingConfig.createEndpoint();
        }
        Preconditions.checkNotNull((Object)this.inMemReader);
        if (this.testSourceType.equals((Object)TestSourceType.InMemSingle)) {
            return new DumpTestSource(this.sourceConfig, this.queryingConfig, this.referenceSchemata, this.inMemReader);
        }
        if (this.testSourceType.equals((Object)TestSourceType.InMemDataset)) {
            return new DatasetTestSource(this.sourceConfig, this.queryingConfig, this.referenceSchemata, this.inMemReader);
        }
        throw new IllegalStateException("Should not be here");
    }

    public String getSparqlEndpoint() {
        return this.sparqlEndpoint;
    }

    public Collection<String> getEndpointGraphs() {
        return this.endpointGraphs;
    }

    private static enum TestSourceType {
        Endpoint,
        InMemSingle,
        InMemDataset;

    }
}

