/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import org.aksw.rdfunit.enums.TestAppliesTo;
import org.aksw.rdfunit.io.reader.RDFReader;
import org.aksw.rdfunit.io.reader.RDFReaderFactory;
import org.aksw.rdfunit.sources.EnrichedSchemaSource;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.SourceConfig;
import org.aksw.rdfunit.utils.CacheUtils;
import org.aksw.rdfunit.utils.StringUtils;

public final class SchemaSourceFactory {
    private SchemaSourceFactory() {
    }

    public static SchemaSource createSchemaSourceFromCache(String baseFolder, String prefix, String uri) {
        return SchemaSourceFactory.createSchemaSourceFromCache(baseFolder, prefix, uri, uri);
    }

    public static SchemaSource createSchemaSourceFromCache(String baseFolder, String prefix, String uri, String schema) {
        String cacheFile = CacheUtils.getSchemaSourceCacheFilename(baseFolder, TestAppliesTo.Schema, prefix, uri);
        RDFReader reader = RDFReaderFactory.createFileOrDereferenceReader(cacheFile, schema);
        return SchemaSourceFactory.createSchemaSourceSimple(prefix, uri, schema, reader);
    }

    public static SchemaSource createSchemaSourceDereference(String prefix, String uri) {
        return SchemaSourceFactory.createSchemaSourceDereference(prefix, uri, uri);
    }

    public static SchemaSource createSchemaSourceDereference(String prefix, String uri, String schema) {
        return SchemaSourceFactory.createSchemaSourceSimple(prefix, uri, schema, RDFReaderFactory.createDereferenceReader(schema));
    }

    public static EnrichedSchemaSource createEnrichedSchemaSourceFromCache(String baseFolder, String prefix, String uri) {
        String cacheFile = CacheUtils.getSchemaSourceCacheFilename(baseFolder, TestAppliesTo.EnrichedSchema, prefix, uri);
        RDFReader reader = RDFReaderFactory.createFileOrDereferenceReader(cacheFile, uri);
        return new EnrichedSchemaSource(new SourceConfig(prefix, uri), reader);
    }

    public static SchemaSource createSchemaSourceFromText(String namespace, String text, String format) {
        String uri = namespace + StringUtils.getHashFromString(text);
        String prefix = CacheUtils.getAutoPrefixForURI(uri);
        return SchemaSourceFactory.createSchemaSourceSimple(prefix, uri, RDFReaderFactory.createReaderFromText(text, format));
    }

    public static SchemaSource createSchemaSourceSimple(String prefix, String uri, RDFReader reader) {
        return SchemaSourceFactory.createSchemaSourceSimple(prefix, uri, uri, reader);
    }

    public static SchemaSource createSchemaSourceSimple(String prefix, String uri, String schema, RDFReader reader) {
        return new SchemaSource(new SourceConfig(prefix, uri), schema, reader);
    }

    public static SchemaSource copySchemaSource(SchemaSource schemaSource) {
        return new SchemaSource(schemaSource);
    }
}

