/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import org.aksw.rdfunit.enums.TestAppliesTo;
import org.aksw.rdfunit.io.reader.RDFReader;
import org.aksw.rdfunit.io.reader.RDFReaderException;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.sources.SourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaSource
implements Source {
    protected static final Logger log = LoggerFactory.getLogger(SchemaSource.class);
    protected final SourceConfig sourceConfig;
    protected final String schema;
    protected final RDFReader schemaReader;
    protected final OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)ModelFactory.createDefaultModel());

    SchemaSource(SourceConfig sourceConfig, RDFReader schemaReader) {
        this(sourceConfig, sourceConfig.getUri(), schemaReader);
    }

    SchemaSource(SourceConfig sourceConfig, String schema, RDFReader schemaReader) {
        this.sourceConfig = sourceConfig;
        this.schema = schema;
        this.schemaReader = schemaReader;
    }

    SchemaSource(SchemaSource source) {
        this.sourceConfig = source.sourceConfig;
        this.schema = source.getSchema();
        this.schemaReader = source.schemaReader;
    }

    @Override
    public String getPrefix() {
        return this.sourceConfig.getPrefix();
    }

    @Override
    public String getUri() {
        return this.sourceConfig.getUri();
    }

    @Override
    public TestAppliesTo getSourceType() {
        return TestAppliesTo.Schema;
    }

    public Model getModel() {
        if (this.model.isEmpty()) {
            try {
                this.schemaReader.read((Model)this.model);
            }
            catch (RDFReaderException e) {
                log.error("Cannot load ontology: {} ", (Object)this.getSchema(), (Object)e);
            }
        }
        return this.model;
    }

    public String getSchema() {
        return this.schema;
    }
}

