/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

final class QueryingConfig {
    private static final long CACHE_TTL = 604800000L;
    private static final long PAGINATION = 800L;
    private static final long QUERY_DELAY = 5000L;
    private static final long QUERY_LIMIT = 799L;
    private final long cacheTTL;
    private final long queryDelay;
    private final long queryLimit;
    private final long pagination;

    private QueryingConfig(long cacheTTL, long queryDelay, long queryLimit, long pagination) {
        this.cacheTTL = cacheTTL;
        this.queryDelay = queryDelay;
        this.queryLimit = queryLimit;
        this.pagination = pagination;
    }

    public static QueryingConfig create() {
        return new QueryingConfig(604800000L, 5000L, 799L, 800L);
    }

    public static QueryingConfig create(long cacheTTL, long queryDelay, long queryLimit, long pagination) {
        return new QueryingConfig(cacheTTL, queryDelay, queryLimit, pagination);
    }

    public static QueryingConfig createEndpoint() {
        return QueryingConfig.create();
    }

    public static QueryingConfig createInMemory() {
        return new QueryingConfig(0L, 0L, 0L, 0L);
    }

    public QueryingConfig copyWithNewCacheTTL(long newCacheTTL) {
        return QueryingConfig.create(newCacheTTL, this.getQueryDelay(), this.getQueryLimit(), this.getPagination());
    }

    public QueryingConfig copyWithNewQueryDelay(long newQueryDelay) {
        return QueryingConfig.create(this.getCacheTTL(), newQueryDelay, this.getQueryLimit(), this.getPagination());
    }

    public QueryingConfig copyWithNewQueryLimit(long newQueryLimit) {
        return QueryingConfig.create(this.getCacheTTL(), this.getQueryDelay(), newQueryLimit, this.getPagination());
    }

    public QueryingConfig copyWithNewPagination(long newPagination) {
        return QueryingConfig.create(this.getCacheTTL(), this.getQueryDelay(), this.getQueryLimit(), newPagination);
    }

    public long getCacheTTL() {
        return this.cacheTTL;
    }

    public long getQueryDelay() {
        return this.queryDelay;
    }

    public long getQueryLimit() {
        return this.queryLimit;
    }

    public long getPagination() {
        return this.pagination;
    }
}

