/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.rdfunit.sources.AbstractTestSource;
import org.aksw.rdfunit.sources.QueryingConfig;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.SourceConfig;
import org.aksw.rdfunit.sources.TestSource;

public class EndpointTestSource
extends AbstractTestSource
implements TestSource {
    private final String sparqlEndpoint;
    private final Collection<String> sparqlGraph;

    EndpointTestSource(SourceConfig sourceConfig, QueryingConfig queryingConfig, Collection<SchemaSource> referenceSchemata, String sparqlEndpoint, Collection<String> sparqlGraph) {
        super(sourceConfig, queryingConfig, referenceSchemata);
        this.sparqlEndpoint = (String)Preconditions.checkNotNull((Object)sparqlEndpoint);
        this.sparqlGraph = Collections.unmodifiableCollection((Collection)Preconditions.checkNotNull(sparqlGraph));
    }

    EndpointTestSource(EndpointTestSource endpointTestSource, Collection<SchemaSource> referenceSchemata) {
        this(endpointTestSource.sourceConfig, endpointTestSource.queryingConfig, referenceSchemata, endpointTestSource.sparqlEndpoint, endpointTestSource.sparqlGraph);
    }

    @Override
    protected QueryExecutionFactory initQueryFactory() {
        QueryExecutionFactoryHttp qef = this.getSparqlGraphs() == null || this.getSparqlGraphs().isEmpty() ? new QueryExecutionFactoryHttp(this.getSparqlEndpoint()) : new QueryExecutionFactoryHttp(this.getSparqlEndpoint(), this.getSparqlGraphs());
        return this.masqueradeQEF((QueryExecutionFactory)qef, this);
    }

    public String getSparqlEndpoint() {
        return this.sparqlEndpoint;
    }

    public Collection<String> getSparqlGraphs() {
        return this.sparqlGraph;
    }
}

