/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import com.google.common.base.Preconditions;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.Collection;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.aksw.rdfunit.io.reader.RDFReader;
import org.aksw.rdfunit.sources.AbstractTestSource;
import org.aksw.rdfunit.sources.QueryingConfig;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.SourceConfig;
import org.aksw.rdfunit.sources.TestSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpTestSource
extends AbstractTestSource
implements TestSource {
    protected static final Logger log = LoggerFactory.getLogger(DumpTestSource.class);
    private final RDFReader dumpReader;
    private final OntModel dumpModel;

    DumpTestSource(SourceConfig sourceConfig, QueryingConfig queryingConfig, Collection<SchemaSource> referenceSchemata, RDFReader dumpReader, OntModel model) {
        super(sourceConfig, queryingConfig, referenceSchemata);
        this.dumpReader = (RDFReader)Preconditions.checkNotNull((Object)dumpReader);
        this.dumpModel = (OntModel)Preconditions.checkNotNull((Object)model);
    }

    DumpTestSource(SourceConfig sourceConfig, QueryingConfig queryingConfig, Collection<SchemaSource> referenceSchemata, RDFReader dumpReader) {
        this(sourceConfig, queryingConfig, referenceSchemata, dumpReader, ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)ModelFactory.createDefaultModel()));
    }

    DumpTestSource(DumpTestSource dumpTestSource, Collection<SchemaSource> referenceSchemata) {
        this(dumpTestSource.sourceConfig, dumpTestSource.queryingConfig, referenceSchemata, dumpTestSource.dumpReader, dumpTestSource.dumpModel);
    }

    @Override
    protected QueryExecutionFactory initQueryFactory() {
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.RDFS_MEM_RDFS_INF, (Model)ModelFactory.createDefaultModel());
        try {
            if (this.dumpModel.isEmpty()) {
                this.dumpReader.read((Model)this.dumpModel);
            }
            for (SchemaSource src : this.getReferencesSchemata()) {
                ontModel.add(src.getModel());
            }
            this.dumpModel.add((Model)ontModel);
        }
        catch (Exception e) {
            log.error("Cannot read dump URI: " + this.getUri() + " Reason: " + e.getMessage());
            throw new IllegalArgumentException("Cannot read dump URI: " + this.getUri() + " Reason: " + e.getMessage(), e);
        }
        return this.masqueradeQEF((QueryExecutionFactory)new QueryExecutionFactoryModel((Model)this.dumpModel), this);
    }
}

