/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import com.google.common.base.Preconditions;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.Collection;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryDataset;
import org.aksw.rdfunit.io.reader.RDFReader;
import org.aksw.rdfunit.sources.AbstractTestSource;
import org.aksw.rdfunit.sources.QueryingConfig;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.SourceConfig;
import org.aksw.rdfunit.sources.TestSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetTestSource
extends AbstractTestSource
implements TestSource {
    protected static final Logger log = LoggerFactory.getLogger(DatasetTestSource.class);
    private final RDFReader dumpReader;
    private final Dataset dumpDataset;

    DatasetTestSource(SourceConfig sourceConfig, QueryingConfig queryingConfig, Collection<SchemaSource> referenceSchemata, RDFReader dumpReader, Dataset dataset) {
        super(sourceConfig, queryingConfig, referenceSchemata);
        this.dumpReader = (RDFReader)Preconditions.checkNotNull((Object)dumpReader);
        this.dumpDataset = (Dataset)Preconditions.checkNotNull((Object)dataset);
    }

    DatasetTestSource(SourceConfig sourceConfig, QueryingConfig queryingConfig, Collection<SchemaSource> referenceSchemata, RDFReader dumpReader) {
        this(sourceConfig, queryingConfig, referenceSchemata, dumpReader, DatasetFactory.createMem());
    }

    DatasetTestSource(DatasetTestSource datasetTestSource, Collection<SchemaSource> referenceSchemata) {
        this(datasetTestSource.sourceConfig, datasetTestSource.queryingConfig, referenceSchemata, datasetTestSource.dumpReader, datasetTestSource.dumpDataset);
    }

    @Override
    protected QueryExecutionFactory initQueryFactory() {
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.RDFS_MEM_RDFS_INF, (Model)ModelFactory.createDefaultModel());
        try {
            if (this.dumpDataset.getDefaultModel().isEmpty() && !this.dumpDataset.listNames().hasNext()) {
                this.dumpReader.readDataset(this.dumpDataset);
            }
            for (SchemaSource src : this.getReferencesSchemata()) {
                ontModel.add(src.getModel());
            }
            this.dumpDataset.setDefaultModel(ontModel.union(this.dumpDataset.getDefaultModel()));
        }
        catch (Exception e) {
            log.error("Cannot read dump URI: " + this.getUri() + " Reason: " + e.getMessage());
            throw new IllegalArgumentException("Cannot read dump URI: " + this.getUri() + " Reason: " + e.getMessage(), e);
        }
        return this.masqueradeQEF((QueryExecutionFactory)new QueryExecutionFactoryDataset(this.dumpDataset), this);
    }
}

