/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import org.aksw.jena_sparql_api.cache.h2.CacheUtilsH2;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.delay.core.QueryExecutionFactoryDelay;
import org.aksw.jena_sparql_api.limit.QueryExecutionFactoryLimit;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionFactoryPaginated;
import org.aksw.rdfunit.enums.TestAppliesTo;
import org.aksw.rdfunit.sources.QueryingConfig;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.SourceConfig;
import org.aksw.rdfunit.sources.TestSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestSource
implements TestSource {
    protected static final Logger log = LoggerFactory.getLogger(TestSource.class);
    protected final SourceConfig sourceConfig;
    protected final QueryingConfig queryingConfig;
    protected final Collection<SchemaSource> referenceSchemata;
    private QueryExecutionFactory queryFactory = null;

    public AbstractTestSource(SourceConfig sourceConfig, QueryingConfig queryingConfig, Collection<SchemaSource> referenceSchemata) {
        this.sourceConfig = (SourceConfig)Preconditions.checkNotNull((Object)sourceConfig);
        this.queryingConfig = (QueryingConfig)Preconditions.checkNotNull((Object)queryingConfig);
        this.referenceSchemata = Collections.unmodifiableCollection((Collection)Preconditions.checkNotNull(referenceSchemata));
    }

    protected abstract QueryExecutionFactory initQueryFactory();

    @Override
    public QueryingConfig getQueryingConfig() {
        return this.queryingConfig;
    }

    @Override
    public Collection<SchemaSource> getReferencesSchemata() {
        return this.referenceSchemata;
    }

    @Override
    public String getPrefix() {
        return this.sourceConfig.getPrefix();
    }

    @Override
    public String getUri() {
        return this.sourceConfig.getUri();
    }

    @Override
    public TestAppliesTo getSourceType() {
        return TestAppliesTo.Dataset;
    }

    @Override
    public QueryExecutionFactory getExecutionFactory() {
        if (this.queryFactory == null) {
            this.queryFactory = this.initQueryFactory();
        }
        return this.queryFactory;
    }

    protected QueryExecutionFactory masqueradeQEF(QueryExecutionFactory originalQEF, TestSource testSource) {
        QueryExecutionFactory qef = originalQEF;
        if (this.queryingConfig.getQueryDelay() > 0L) {
            qef = new QueryExecutionFactoryDelay(qef, this.queryingConfig.getQueryDelay());
        }
        if (this.queryingConfig.getCacheTTL() > 0L) {
            try {
                qef = CacheUtilsH2.createQueryExecutionFactory((QueryExecutionFactory)qef, (String)("./cache/sparql/" + testSource.getPrefix()), (boolean)false, (long)this.queryingConfig.getCacheTTL());
                log.debug("Cache for endpoint set up: " + testSource.getUri());
            }
            catch (Exception e) {
                log.debug("Could not instantiate cache for Endpoint" + testSource.getUri(), (Throwable)e);
            }
        }
        if (this.queryingConfig.getPagination() > 0L) {
            qef = new QueryExecutionFactoryPaginated(qef, this.queryingConfig.getPagination());
        }
        if (this.queryingConfig.getQueryLimit() > 0L) {
            qef = new QueryExecutionFactoryLimit(qef, true, Long.valueOf(this.queryingConfig.getQueryLimit()));
        }
        return qef;
    }

    public long getCacheTTL() {
        return this.queryingConfig.getCacheTTL();
    }

    public long getQueryDelay() {
        return this.queryingConfig.getQueryDelay();
    }

    public long getQueryLimit() {
        return this.queryingConfig.getQueryLimit();
    }

    public long getPagination() {
        return this.queryingConfig.getPagination();
    }
}

