/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io.writer;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.io.IOUtils;
import org.aksw.rdfunit.io.writer.AbstractRDFWriter;
import org.aksw.rdfunit.io.writer.RDFWriter;
import org.aksw.rdfunit.io.writer.RDFWriterException;
import org.aksw.rdfunit.services.PrefixNSService;

public class RDFStreamWriter
extends AbstractRDFWriter
implements RDFWriter {
    private final OutputStream outputStream;
    private final String filetype;

    public RDFStreamWriter(OutputStream outputStream, String filetype) {
        this.outputStream = outputStream;
        this.filetype = filetype;
    }

    public RDFStreamWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.filetype = "TURTLE";
    }

    @Override
    public void write(QueryExecutionFactory qef) throws RDFWriterException {
        try {
            Model model = IOUtils.getModelFromQueryFactory(qef);
            PrefixNSService.setNSPrefixesInModel(model);
            model.write(this.outputStream, this.filetype);
        }
        catch (Exception e) {
            throw new RDFWriterException("Error writing in OutputStream: " + e.getMessage(), e);
        }
    }

    public static OutputStream getOutputStreamFromFilename(String filename) {
        try {
            return new FileOutputStream(filename);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

