/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io.writer;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.io.OutputStream;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.io.writer.RDFHTMLResultsWriter;
import org.aksw.rdfunit.io.writer.RDFWriterException;
import org.aksw.rdfunit.services.PrefixNSService;

public class RDFHTMLResultsRlogWriter
extends RDFHTMLResultsWriter {
    public RDFHTMLResultsRlogWriter(String filename) {
        super(filename);
    }

    public RDFHTMLResultsRlogWriter(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    protected StringBuffer getResultsHeader() {
        return new StringBuffer("<tr><th>Level</th><th>Message</th><th>Resource</th><th>Test Case</th></tr>");
    }

    @Override
    protected StringBuffer getResultsList(QueryExecutionFactory qef, String testExecutionURI) throws RDFWriterException {
        StringBuffer results = new StringBuffer();
        String template = "<tr class=\"%s\"><td>%s</td><td>%s</ts><td><a href=\"%s\">%s</a></td><td>%s</td></tr>";
        String sparql = PrefixNSService.getSparqlPrefixDecl() + " SELECT DISTINCT ?level ?message ?resource ?testcase WHERE {" + " ?s a rut:RLOGTestCaseResult ; " + "    rlog:level ?level ;" + "    rlog:message ?message ; " + "    rlog:resource ?resource ; " + "    rut:testCase ?testcase ; " + "} ";
        try (QueryExecution qe = null;){
            qe = qef.createQueryExecution(sparql);
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                String level = qs.get("level").toString();
                String message = qs.get("message").toString();
                String resource = qs.get("resource").toString();
                String testcase = qs.get("testcase").toString();
                String levelShort = PrefixNSService.getLocalName(level, "rlog");
                String rowClass = "";
                switch (levelShort) {
                    case "WARN": {
                        rowClass = "warning";
                        break;
                    }
                    case "ERROR": {
                        rowClass = "danger";
                        break;
                    }
                    case "INFO": {
                        rowClass = "info";
                        break;
                    }
                }
                String row = String.format(template, rowClass, "<a href=\"" + level + "\">" + levelShort + "</a>", message, resource, resource, testcase.replace(PrefixNSService.getNSFromPrefix("rutt"), "rutt:"));
                results.append(row);
            }
        }
        return results;
    }
}

