/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io.reader;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import org.aksw.rdfunit.io.reader.AbstractRDFReader;
import org.aksw.rdfunit.io.reader.RDFReader;
import org.aksw.rdfunit.io.reader.RDFReaderException;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.LangBuilder;
import org.apache.jena.riot.RDFDataMgr;
import org.semarglproject.jena.rdf.rdfa.JenaRdfaReader;

public class RDFaReader
extends AbstractRDFReader
implements RDFReader {
    private final String uri;

    public RDFaReader(String uri) {
        this.uri = uri;
    }

    @Override
    public void read(Model model) throws RDFReaderException {
        try {
            JenaRdfaReader.inject();
            model.read(this.uri, null, "RDFA");
        }
        catch (Exception e) {
            throw new RDFReaderException(e);
        }
    }

    @Override
    public void readDataset(Dataset dataset) throws RDFReaderException {
        try {
            JenaRdfaReader.inject();
            RDFDataMgr.read((Dataset)dataset, (String)this.uri, null, (Lang)LangBuilder.create((String)"RDFA", (String)"text/html").build());
        }
        catch (Exception e) {
            throw new RDFReaderException(e);
        }
    }

    public String toString() {
        return "RDFaReader{uri='" + this.uri + '\'' + '}';
    }
}

