/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io.reader;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.aksw.rdfunit.io.format.FormatService;
import org.aksw.rdfunit.io.reader.AbstractRDFReader;
import org.aksw.rdfunit.io.reader.RDFReader;
import org.aksw.rdfunit.io.reader.RDFReaderException;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.semarglproject.jena.rdf.rdfa.JenaRdfaReader;

public class RDFStreamReader
extends AbstractRDFReader
implements RDFReader {
    private final InputStream inputStream;
    private final String format;

    public RDFStreamReader(String filename) {
        this(RDFStreamReader.getInputStreamFromFilename(filename), FormatService.getFormatFromExtension(filename));
    }

    public RDFStreamReader(String filename, String format) {
        this(RDFStreamReader.getInputStreamFromFilename(filename), format);
    }

    public RDFStreamReader(InputStream inputStream, String format) {
        this.inputStream = inputStream;
        this.format = format;
    }

    @Override
    public void read(Model model) throws RDFReaderException {
        try {
            if ("RDFA".equals(this.format)) {
                JenaRdfaReader.inject();
            }
            RDFDataMgr.read((Model)model, (InputStream)this.inputStream, null, (Lang)RDFLanguages.nameToLang((String)this.format));
        }
        catch (Exception e) {
            throw new RDFReaderException(e.getMessage(), e);
        }
    }

    @Override
    public void readDataset(Dataset dataset) throws RDFReaderException {
        try {
            if ("RDFA".equals(this.format)) {
                JenaRdfaReader.inject();
            }
            RDFDataMgr.read((Dataset)dataset, (InputStream)this.inputStream, null, (Lang)RDFLanguages.nameToLang((String)this.format));
        }
        catch (Exception e) {
            throw new RDFReaderException(e.getMessage(), e);
        }
    }

    private static InputStream getInputStreamFromFilename(String filename) {
        try {
            return new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public String toString() {
        return "RDFStreamReader{inputStream=" + this.inputStream + ", format=" + this.format + '}';
    }
}

