/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io.reader;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.aksw.rdfunit.io.IOUtils;
import org.aksw.rdfunit.io.format.FormatService;
import org.aksw.rdfunit.io.reader.RDFDereferenceReader;
import org.aksw.rdfunit.io.reader.RDFFirstSuccessReader;
import org.aksw.rdfunit.io.reader.RDFReadAndCacheReader;
import org.aksw.rdfunit.io.reader.RDFReader;
import org.aksw.rdfunit.io.reader.RDFStreamReader;
import org.aksw.rdfunit.io.reader.RDFaReader;
import org.aksw.rdfunit.io.writer.RDFFileWriter;

public final class RDFReaderFactory {
    private RDFReaderFactory() {
    }

    public static RDFReader createFileOrDereferenceReader(String filename, String uri) {
        ArrayList<RDFReader> readers = new ArrayList<RDFReader>();
        readers.add(new RDFStreamReader(filename));
        readers.add(new RDFDereferenceReader(uri));
        RDFFirstSuccessReader r = new RDFFirstSuccessReader(readers);
        RDFFileWriter w = new RDFFileWriter(filename, true);
        return new RDFReadAndCacheReader(r, w);
    }

    public static RDFReader createResourceReader(String resource) {
        return new RDFStreamReader(RDFReaderFactory.class.getResourceAsStream(resource), FormatService.getFormatFromExtension(resource));
    }

    public static RDFReader createFileOrResourceReader(String filename, String resource) {
        ArrayList<RDFReader> readers = new ArrayList<RDFReader>();
        readers.add(new RDFStreamReader(filename));
        readers.add(RDFReaderFactory.createResourceReader(resource));
        return new RDFFirstSuccessReader(readers);
    }

    public static RDFReader createDereferenceReader(String uri) {
        ArrayList<RDFReader> readers = new ArrayList<RDFReader>();
        if (!IOUtils.isFile(uri)) {
            readers.add(new RDFDereferenceReader(uri));
            readers.add(new RDFaReader(uri));
        } else {
            readers.add(new RDFStreamReader(uri));
            readers.add(RDFReaderFactory.createResourceReader(uri));
        }
        return new RDFFirstSuccessReader(readers);
    }

    public static RDFReader createReaderFromText(String text, String format) {
        ByteArrayInputStream is;
        try {
            is = new ByteArrayInputStream(text.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid source name: " + text, e);
        }
        return new RDFStreamReader(is, format);
    }
}

