/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io.reader;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import java.util.Collection;
import org.aksw.rdfunit.io.reader.AbstractRDFReader;
import org.aksw.rdfunit.io.reader.RDFReader;
import org.aksw.rdfunit.io.reader.RDFReaderException;

public class RDFFirstSuccessReader
extends AbstractRDFReader
implements RDFReader {
    private final Collection<RDFReader> readers;

    public RDFFirstSuccessReader(Collection<RDFReader> readers) {
        this.readers = readers;
    }

    @Override
    public void read(Model model) throws RDFReaderException {
        StringBuilder message = new StringBuilder();
        for (RDFReader r : this.readers) {
            try {
                r.read(model);
                return;
            }
            catch (RDFReaderException e) {
                message.append("\n");
                if (e.getMessage() != null) {
                    message.append(e.getMessage());
                    continue;
                }
                message.append(e);
            }
        }
        throw new RDFReaderException("Cannot read from any reader: " + message.toString());
    }

    @Override
    public void readDataset(Dataset dataset) throws RDFReaderException {
        StringBuilder message = new StringBuilder();
        for (RDFReader r : this.readers) {
            try {
                r.readDataset(dataset);
                return;
            }
            catch (RDFReaderException e) {
                message.append("\n");
                if (e.getMessage() != null) {
                    message.append(e.getMessage());
                    continue;
                }
                message.append(e);
            }
        }
        throw new RDFReaderException("Cannot read from any reader: " + message.toString());
    }

    public String toString() {
        return "RDFFirstSuccessReader{readers=" + this.readers + '}';
    }
}

