/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io.reader;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.NotFoundException;
import java.io.File;
import org.aksw.rdfunit.io.reader.AbstractRDFReader;
import org.aksw.rdfunit.io.reader.RDFReader;
import org.aksw.rdfunit.io.reader.RDFReaderException;
import org.apache.jena.riot.RDFDataMgr;

public class RDFDereferenceReader
extends AbstractRDFReader
implements RDFReader {
    private final String uri;

    public RDFDereferenceReader(String uri) {
        File file = new File(uri);
        this.uri = file.exists() ? file.getAbsolutePath() : uri;
    }

    @Override
    public void read(Model model) throws RDFReaderException {
        try {
            RDFDataMgr.read((Model)model, (String)this.uri);
        }
        catch (NotFoundException e) {
            throw new RDFReaderException("'" + this.uri + "' not found", e);
        }
        catch (Exception e) {
            throw new RDFReaderException(e);
        }
    }

    @Override
    public void readDataset(Dataset dataset) throws RDFReaderException {
        try {
            RDFDataMgr.read((Dataset)dataset, (String)this.uri);
        }
        catch (NotFoundException e) {
            throw new RDFReaderException("'" + this.uri + "' not found", e);
        }
        catch (Exception e) {
            throw new RDFReaderException(e);
        }
    }

    public String toString() {
        return "RDFDereferenceReader{uri='" + this.uri + '\'' + '}';
    }
}

