/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io.format;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import org.aksw.rdfunit.io.format.SerializationFormatGraphType;
import org.aksw.rdfunit.io.format.SerializationFormatIOType;

public class SerializationFormat {
    private final String name;
    private final SerializationFormatIOType ioType;
    private final SerializationFormatGraphType graphType;
    private final String extension;
    private final String headerType;
    private final Set<String> synonyms;

    public SerializationFormat(String name, SerializationFormatIOType ioType, SerializationFormatGraphType graphType, String extension, String headerType) {
        this(name, ioType, graphType, extension, headerType, new HashSet<String>());
    }

    public SerializationFormat(String name, SerializationFormatIOType ioType, SerializationFormatGraphType graphType, String extension, String headerType, Set<String> synonyms) {
        this.name = name;
        this.ioType = ioType;
        this.graphType = graphType;
        this.extension = extension;
        this.headerType = headerType;
        this.synonyms = new HashSet<String>();
        for (String synonym : synonyms) {
            this.synonyms.add(synonym.toLowerCase());
        }
    }

    public boolean isAcceptedAsInput(String format) {
        return this.isAcceptedAsAny(format, SerializationFormatIOType.output);
    }

    public boolean isAcceptedAsOutput(String format) {
        return this.isAcceptedAsAny(format, SerializationFormatIOType.input);
    }

    private boolean isAcceptedAsAny(String format, SerializationFormatIOType formatType) {
        return !this.ioType.equals((Object)formatType) && this.containsFormatName(format);
    }

    private boolean containsFormatName(String format) {
        return this.name.equalsIgnoreCase(format) || this.synonyms.contains(format.toLowerCase());
    }

    public String getName() {
        return this.name;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getHeaderType() {
        return this.headerType;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.ioType, this.graphType, this.extension, this.headerType, this.synonyms});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SerializationFormat other = (SerializationFormat)obj;
        return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)((Object)this.ioType), (Object)((Object)other.ioType)) && Objects.equal((Object)((Object)this.graphType), (Object)((Object)other.graphType)) && Objects.equal((Object)this.extension, (Object)other.extension) && Objects.equal((Object)this.headerType, (Object)other.headerType) && Objects.equal(this.synonyms, other.synonyms);
    }

    public SerializationFormatIOType getIoType() {
        return this.ioType;
    }

    public SerializationFormatGraphType getGraphType() {
        return this.graphType;
    }
}

