/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io.format;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.aksw.rdfunit.io.format.SerializationFormat;
import org.aksw.rdfunit.io.format.SerializationFormatGraphType;
import org.aksw.rdfunit.io.format.SerializationFormatIOType;

public final class SerialiazationFormatFactory {
    private SerialiazationFormatFactory() {
    }

    public static Collection<SerializationFormat> getAllFormats() {
        ArrayList<SerializationFormat> serializationFormats = new ArrayList<SerializationFormat>();
        serializationFormats.add(SerialiazationFormatFactory.createTurtle());
        serializationFormats.add(SerialiazationFormatFactory.createN3());
        serializationFormats.add(SerialiazationFormatFactory.createNTriples());
        serializationFormats.add(SerialiazationFormatFactory.createJsonLD());
        serializationFormats.add(SerialiazationFormatFactory.createRDFJson());
        serializationFormats.add(SerialiazationFormatFactory.createRDFXMLAbbrevOut());
        serializationFormats.add(SerialiazationFormatFactory.createRDFXMLIn());
        serializationFormats.add(SerialiazationFormatFactory.createRDFXMLOut());
        serializationFormats.add(SerialiazationFormatFactory.createRDFa());
        serializationFormats.add(SerialiazationFormatFactory.createHTML());
        serializationFormats.add(SerialiazationFormatFactory.createNQads());
        serializationFormats.add(SerialiazationFormatFactory.createTriG());
        serializationFormats.add(SerialiazationFormatFactory.createTriX());
        return serializationFormats;
    }

    public static SerializationFormat createHTML() {
        HashSet currentSynonyms = Sets.newHashSet(Arrays.asList("html", "htm"));
        return new SerializationFormat("html", SerializationFormatIOType.output, SerializationFormatGraphType.singleGraph, "html", "text/html", currentSynonyms);
    }

    public static SerializationFormat createTurtle() {
        HashSet currentSynonyms = Sets.newHashSet(Arrays.asList("turtle", "ttl"));
        return new SerializationFormat("TURTLE", SerializationFormatIOType.inputAndOutput, SerializationFormatGraphType.singleGraph, "ttl", "text/turtle", currentSynonyms);
    }

    public static SerializationFormat createN3() {
        HashSet currentSynonyms = Sets.newHashSet();
        return new SerializationFormat("N3", SerializationFormatIOType.inputAndOutput, SerializationFormatGraphType.singleGraph, "n3", "rdf+n3", currentSynonyms);
    }

    public static SerializationFormat createNTriples() {
        HashSet currentSynonyms = Sets.newHashSet(Arrays.asList("n-triple", "n-triples", "ntriple", "ntriples", "nt"));
        return new SerializationFormat("N-TRIPLE", SerializationFormatIOType.inputAndOutput, SerializationFormatGraphType.singleGraph, "nt", "application/n-triples", currentSynonyms);
    }

    public static SerializationFormat createJsonLD() {
        HashSet currentSynonyms = Sets.newHashSet(Arrays.asList("JSON-LD", "JSONLD", "JSON/LD"));
        return new SerializationFormat("JSON-LD", SerializationFormatIOType.inputAndOutput, SerializationFormatGraphType.singleGraph, "jsonld", "application/ld+json", currentSynonyms);
    }

    public static SerializationFormat createRDFJson() {
        HashSet currentSynonyms = Sets.newHashSet(Arrays.asList("RDF/JSON", "RDF-JSON", "RDFJSON", "RJ"));
        return new SerializationFormat("RDF/JSON", SerializationFormatIOType.inputAndOutput, SerializationFormatGraphType.singleGraph, "rj", "application/rdf+json", currentSynonyms);
    }

    public static SerializationFormat createRDFXMLAbbrevOut() {
        HashSet currentSynonyms = Sets.newHashSet(Arrays.asList("RDF/XML-ABBREV", "RDF-XML-ABBREV", "RDFXMLABBREV"));
        return new SerializationFormat("RDF/XML-ABBREV", SerializationFormatIOType.output, SerializationFormatGraphType.singleGraph, "rdf", "application/rdf+xml", currentSynonyms);
    }

    public static SerializationFormat createRDFXMLOut() {
        HashSet currentSynonyms = Sets.newHashSet(Arrays.asList("RDF/XML", "RDF-XML", "RDFXML"));
        return new SerializationFormat("RDF/XML", SerializationFormatIOType.output, SerializationFormatGraphType.singleGraph, "rdf", "application/rdf+xml", currentSynonyms);
    }

    public static SerializationFormat createRDFXMLIn() {
        HashSet currentSynonyms = Sets.newHashSet((Object[])new String[]{"RDF/XML", "RDF-XML", "RDFXML", "RDF/XML-ABBREV", "RDF-XML-ABBREV", "RDFXML-ABBREV", "RDFXMLABBREV", "RDF", "XML"});
        return new SerializationFormat("RDF/XML", SerializationFormatIOType.input, SerializationFormatGraphType.singleGraph, "rdf", "application/rdf+xml", currentSynonyms);
    }

    public static SerializationFormat createRDFa() {
        HashSet currentSynonyms = Sets.newHashSet(Arrays.asList("RDFa", "html", "htm"));
        return new SerializationFormat("RDFA", SerializationFormatIOType.input, SerializationFormatGraphType.singleGraph, "html", "text/html", currentSynonyms);
    }

    public static SerializationFormat createNQads() {
        HashSet currentSynonyms = Sets.newHashSet(Arrays.asList("nq", "nquads", "n-quads", "nquad", "n-quad"));
        return new SerializationFormat("NQuads", SerializationFormatIOType.inputAndOutput, SerializationFormatGraphType.dataset, "nq", "text/n-quads", currentSynonyms);
    }

    public static SerializationFormat createTriX() {
        HashSet currentSynonyms = Sets.newHashSet(Arrays.asList("trix"));
        return new SerializationFormat("TriX", SerializationFormatIOType.inputAndOutput, SerializationFormatGraphType.dataset, "trix", "application/trix", currentSynonyms);
    }

    public static SerializationFormat createTriG() {
        HashSet currentSynonyms = Sets.newHashSet(Arrays.asList("trig"));
        return new SerializationFormat("TriG", SerializationFormatIOType.inputAndOutput, SerializationFormatGraphType.dataset, "trix", "application/x-trig", currentSynonyms);
    }
}

