/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io.format;

import java.util.Collection;
import org.aksw.rdfunit.io.format.SerialiazationFormatFactory;
import org.aksw.rdfunit.io.format.SerializationFormat;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;

public final class FormatService {
    private FormatService() {
    }

    public static SerializationFormat getInputFormat(String name) {
        for (SerializationFormat ft : Instance.serializationFormats) {
            if (!ft.isAcceptedAsInput(name)) continue;
            return ft;
        }
        return null;
    }

    public static SerializationFormat getOutputFormat(String name) {
        for (SerializationFormat ft : Instance.serializationFormats) {
            if (!ft.isAcceptedAsOutput(name)) continue;
            return ft;
        }
        return null;
    }

    public static String getFormatFromExtension(String filename) {
        String format = "TURTLE";
        try {
            String extension = "";
            Lang jenaLang = RDFLanguages.filenameToLang((String)filename);
            if (jenaLang != null) {
                extension = (String)jenaLang.getFileExtensions().get(0);
            } else {
                int index = filename.lastIndexOf(46);
                extension = filename.substring(index + 1, filename.length());
            }
            SerializationFormat f = FormatService.getInputFormat(extension);
            if (f != null) {
                format = f.getName();
            }
        }
        catch (Exception e) {
            return "TURTLE";
        }
        return format;
    }

    private static final class Instance {
        private static final Collection<SerializationFormat> serializationFormats = SerialiazationFormatFactory.getAllFormats();

        private Instance() {
        }
    }
}

