/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;

public final class IOUtils {
    private IOUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model getModelFromQueryFactory(QueryExecutionFactory qef) {
        if (qef instanceof QueryExecutionFactoryModel) {
            return ((QueryExecutionFactoryModel)qef).getModel();
        }
        try (QueryExecution qe = null;){
            qe = qef.createQueryExecution(" CONSTRUCT ?s ?p ?o WHERE { ?s ?p ?o } ");
            Model model = qe.execConstruct();
            return model;
        }
    }

    public static boolean isURI(String uri) {
        try {
            new URI(uri);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isFile(String filename) {
        return new File(filename).exists();
    }
}

