/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.coverage;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.services.PrefixNSService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCoverageEvaluator {
    private static final Logger log = LoggerFactory.getLogger(TestCoverageEvaluator.class);
    private final Collection<String> fDomPatterns = Arrays.asList("RDFSDOMAIN", "OWLDISJP", "TYPRODEP", "OWLSYMMETRICPROP", "OWLASYMMETRICPROP", "OWLTRANSPROP", "COMP", "LITRAN", "TYPDEP", "PVT");
    private final Collection<String> fRangPatterns = Arrays.asList("RDFSRANGE", "OWLDISJP", "OWLCARD", "INVFUNC", "OWLSYMMETRICPROP", "OWLASYMMETRICPROP", "OWLTRANSPROP", "COMP", "MATCH", "LITRAN", "ONELANG");
    private final Collection<String> fDepPatterns = Arrays.asList("RDFSRANGE", "RDFSDOMAIN", "OWLDISJP", "TYPRODEP", "COMP", "LITRAN", "PVT");
    private final Collection<String> fCardPatterns = Arrays.asList("OWLCARD", "ONELANG");
    private final Collection<String> fMemPatterns = Arrays.asList("RDFSRANGE", "RDFSDOMAIN", "OWLDISJP", "TYPRODEP", "LITRAN");
    private final Collection<String> fCDepPatterns = Arrays.asList("OWLDISJC", "TYPDEP");
    private final String sparql = PrefixNSService.getSparqlPrefixDecl() + " SELECT distinct ?reference WHERE {\n" + "   ?t a  rut:TestCase ; \n" + "      rut:basedOnPattern ?pattern ; \n" + "      rut:references ?reference .\n" + "   VALUES ( ?pattern )  { %%PATTERNS%%} }";

    private String generateInClause(Collection<String> patterns) {
        StringBuilder inClause = new StringBuilder();
        for (String s : patterns) {
            inClause.append(" ( <").append(PrefixNSService.getNSFromPrefix("rutp")).append(s).append("> ) ");
        }
        return inClause.toString();
    }

    public void calculateCoverage(QueryExecutionFactory qef, String propertiesFile, String classFile) throws IOException {
        String line;
        long propertiesTotal = 0L;
        long classesTotal = 0L;
        HashMap<String, Long> properties = new HashMap<String, Long>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(propertiesFile), "UTF8"));){
            while ((line = br.readLine()) != null) {
                String[] ar = line.split(" ");
                long count = Long.parseLong(ar[0].trim());
                String ref = ar[1].trim();
                propertiesTotal += count;
                properties.put(ref, count);
            }
        }
        HashMap<String, Long> classes = new HashMap<String, Long>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(classFile), "UTF8"));){
            while ((line = br.readLine()) != null) {
                String[] ar = line.split(" ");
                long count = Long.parseLong(ar[0].trim());
                String ref = ar[1].trim();
                classesTotal += count;
                classes.put(ref, count);
            }
        }
        this.calculateCoverage(qef, properties, propertiesTotal, classes, classesTotal);
    }

    private void calculateCoverage(QueryExecutionFactory model, Map<String, Long> propertyCount, long totalProperties, Map<String, Long> classCount, long totalClasses) {
        Collection<String> references;
        if (totalProperties > 0L) {
            references = this.getReferenceSet(model, this.sparql.replace("%%PATTERNS%%", this.generateInClause(this.fDomPatterns)));
            double fDom = this.getCoverage(references, propertyCount, totalProperties);
            log.info("Fdom Coverage: {}", (Object)fDom);
            references = this.getReferenceSet(model, this.sparql.replace("%%PATTERNS%%", this.generateInClause(this.fRangPatterns)));
            double fRang = this.getCoverage(references, propertyCount, totalProperties);
            log.info("fRang Coverage: {}", (Object)fRang);
            references = this.getReferenceSet(model, this.sparql.replace("%%PATTERNS%%", this.generateInClause(this.fDepPatterns)));
            double fDep = this.getCoverage(references, propertyCount, totalProperties);
            log.info("fDep Coverage: {}", (Object)fDep);
            references = this.getReferenceSet(model, this.sparql.replace("%%PATTERNS%%", this.generateInClause(this.fCardPatterns)));
            double fCard = this.getCoverage(references, propertyCount, totalProperties);
            log.info("fCard Coverage: {}", (Object)fCard);
        } else {
            log.warn("No properties found in Source (probably source is empty)");
        }
        if (totalClasses > 0L) {
            references = this.getReferenceSet(model, this.sparql.replace("%%PATTERNS%%", this.generateInClause(this.fMemPatterns)));
            double fMem = this.getCoverage(references, classCount, totalClasses);
            log.info("fMem Coverage: {}", (Object)fMem);
            references = this.getReferenceSet(model, this.sparql.replace("%%PATTERNS%%", this.generateInClause(this.fCDepPatterns)));
            double fCDep = this.getCoverage(references, classCount, totalClasses);
            log.info("fCDep Coverage: {}", (Object)fCDep);
        } else {
            log.warn("No Class usage found in Source");
        }
    }

    private double getCoverage(Collection<String> references, Map<String, Long> referencesCount, long totalReferences) {
        double coverage = 0.0;
        for (String reference : references) {
            Long count = referencesCount.get(reference);
            if (count == null) continue;
            coverage += (double)count.longValue() / (double)totalReferences;
        }
        return coverage;
    }

    private Collection<String> getReferenceSet(QueryExecutionFactory model, String query) {
        ArrayList<String> references = new ArrayList<String>();
        Query q = QueryFactory.create((String)query);
        QueryExecution qe = model.createQueryExecution(q);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            QuerySolution row = rs.next();
            references.add("<" + row.get("reference").toString() + ">");
        }
        qe.close();
        return references;
    }
}

