/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit;

import java.util.ArrayList;
import java.util.Collection;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.enums.TestCaseExecutionType;
import org.aksw.rdfunit.exceptions.UndefinedSchemaException;
import org.aksw.rdfunit.exceptions.UndefinedSerializationException;
import org.aksw.rdfunit.io.format.FormatService;
import org.aksw.rdfunit.io.format.SerializationFormat;
import org.aksw.rdfunit.io.reader.RDFReaderFactory;
import org.aksw.rdfunit.services.SchemaService;
import org.aksw.rdfunit.sources.EnrichedSchemaSource;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.SchemaSourceFactory;
import org.aksw.rdfunit.sources.TestSource;
import org.aksw.rdfunit.sources.TestSourceBuilder;
import org.aksw.rdfunit.sources.TestSourceFactory;
import org.aksw.rdfunit.statistics.NamespaceStatistics;
import org.aksw.rdfunit.utils.CacheUtils;
import org.aksw.rdfunit.utils.RDFUnitUtils;

public class RDFUnitConfiguration {
    private final String datasetURI;
    private String prefix = null;
    private final String dataFolder;
    private final String testFolder;
    private long endpointQueryDelayMS = -1L;
    private long endpointQueryCacheTTL = -1L;
    private long endpointQueryPagination = -1L;
    private long endpointQueryLimit = -1L;
    private String customDereferenceURI = null;
    private TestSource testSource = null;
    private TestSourceBuilder testSourceBuilder = new TestSourceBuilder();
    private Collection<SchemaSource> schemas = null;
    private EnrichedSchemaSource enrichedSchema = null;
    private boolean testCacheEnabled = true;
    private boolean manualTestsEnabled = true;
    private boolean autoTestsEnabled = true;
    private TestCaseExecutionType testCaseExecutionType = TestCaseExecutionType.aggregatedTestCaseResult;
    private Collection<SerializationFormat> outputFormats = null;
    private boolean calculateCoverageEnabled = false;

    public RDFUnitConfiguration(String datasetURI, String dataFolder) {
        this(datasetURI, dataFolder, dataFolder + "tests/");
    }

    public RDFUnitConfiguration(String datasetURI, String dataFolder, String testFolder) {
        this.datasetURI = datasetURI;
        this.dataFolder = dataFolder;
        this.testFolder = testFolder;
        this.prefix = CacheUtils.getAutoPrefixForURI(datasetURI);
    }

    public void setEndpointConfiguration(String endpointURI, Collection<String> endpointGraphs) {
        this.testSourceBuilder.setEndpoint(endpointURI, endpointGraphs);
    }

    public void setCustomDereferenceURI(String customDereferenceURI) {
        this.testSourceBuilder.setImMemFromUri(customDereferenceURI);
        this.customDereferenceURI = customDereferenceURI;
    }

    public void setCustomTextSource(String text, String format) throws UndefinedSerializationException {
        this.testSourceBuilder.setInMemFromCustomText(text, format);
    }

    public void setAutoSchemataFromQEF(QueryExecutionFactory qef) {
        this.setAutoSchemataFromQEF(qef, false);
    }

    public void setAutoSchemataFromQEF(QueryExecutionFactory qef, boolean all) {
        this.setAutoSchemataFromQEF(qef, all, true);
    }

    public void setAutoSchemataFromQEF(QueryExecutionFactory qef, boolean all, boolean limitToKnown) {
        NamespaceStatistics namespaceStatistics;
        if (all) {
            namespaceStatistics = limitToKnown ? NamespaceStatistics.createCompleteNSStatisticsKnown() : NamespaceStatistics.createCompleteNSStatisticsAll();
        } else {
            NamespaceStatistics namespaceStatistics2 = namespaceStatistics = limitToKnown ? NamespaceStatistics.createOntologyNSStatisticsKnown() : NamespaceStatistics.createOntologyNSStatisticsAll();
        }
        assert (namespaceStatistics != null);
        this.schemas = namespaceStatistics.getNamespaces(qef);
    }

    public void setSchemataFromPrefixes(Collection<String> schemaPrefixes) throws UndefinedSchemaException {
        this.schemas = SchemaService.getSourceList(this.testFolder, schemaPrefixes);
    }

    public void setSchemata(Collection<SchemaSource> schemata) {
        this.schemas = new ArrayList<SchemaSource>();
        this.schemas.addAll(schemata);
    }

    public void setEnrichedSchema(String enrichedSchemaPrefix) {
        if (enrichedSchemaPrefix != null && !enrichedSchemaPrefix.isEmpty()) {
            this.enrichedSchema = SchemaSourceFactory.createEnrichedSchemaSourceFromCache(this.testFolder, enrichedSchemaPrefix, this.datasetURI);
        }
    }

    public Collection<SchemaSource> getAllSchemata() {
        ArrayList<SchemaSource> allSchemas = new ArrayList<SchemaSource>();
        if (this.schemas != null) {
            allSchemas.addAll(this.schemas);
        }
        if (this.enrichedSchema != null) {
            allSchemas.add(this.enrichedSchema);
        }
        return allSchemas;
    }

    public TestSource getTestSource() {
        if (this.testSource != null) {
            Collection<SchemaSource> schemata = this.getAllSchemata();
            if (this.testSource.getReferencesSchemata().isEmpty() && !schemata.isEmpty()) {
                this.testSource = TestSourceFactory.createTestSource(this.testSource, schemata);
            }
            return this.testSource;
        }
        this.testSourceBuilder.setPrefixUri(this.prefix, this.datasetURI);
        this.testSourceBuilder.setReferenceSchemata(this.getAllSchemata());
        if (this.customDereferenceURI != null && "-".equals(this.customDereferenceURI)) {
            this.testSourceBuilder.setInMemFromPipe();
        }
        if (this.getEndpointURI() == null || this.getEndpointURI().isEmpty()) {
            String tmp_customDereferenceURI = this.datasetURI;
            if (this.customDereferenceURI != null && !this.customDereferenceURI.isEmpty()) {
                tmp_customDereferenceURI = this.customDereferenceURI;
            }
            this.testSourceBuilder.setInMemReader(RDFReaderFactory.createDereferenceReader(tmp_customDereferenceURI));
        }
        if (this.endpointQueryCacheTTL != -1L) {
            this.testSourceBuilder.setCacheTTL(this.endpointQueryCacheTTL);
        }
        if (this.endpointQueryDelayMS != -1L) {
            this.testSourceBuilder.setQueryDelay(this.endpointQueryDelayMS);
        }
        if (this.endpointQueryPagination != -1L) {
            this.testSourceBuilder.setPagination(this.endpointQueryPagination);
        }
        if (this.endpointQueryLimit != -1L) {
            this.testSourceBuilder.setQueryLimit(this.endpointQueryLimit);
        }
        this.testSource = this.testSourceBuilder.build();
        return this.testSource;
    }

    public void setOutputFormatTypes(Collection<String> outputNames) throws UndefinedSerializationException {
        this.outputFormats = new ArrayList<SerializationFormat>();
        for (String name : outputNames) {
            SerializationFormat serializationFormat = FormatService.getOutputFormat(name);
            if (serializationFormat != null) {
                this.outputFormats.add(serializationFormat);
                continue;
            }
            throw new UndefinedSerializationException(name);
        }
        if (this.outputFormats.isEmpty()) {
            throw new UndefinedSerializationException("");
        }
    }

    public boolean isTestCacheEnabled() {
        return this.testCacheEnabled;
    }

    public void setTestCacheEnabled(boolean testCacheEnabled) {
        this.testCacheEnabled = testCacheEnabled;
    }

    public boolean isManualTestsEnabled() {
        return this.manualTestsEnabled;
    }

    public void setManualTestsEnabled(boolean manualTestsEnabled) {
        this.manualTestsEnabled = manualTestsEnabled;
    }

    public boolean isAutoTestsEnabled() {
        return this.autoTestsEnabled;
    }

    public void setAutoTestsEnabled(boolean autoTestsEnabled) {
        this.autoTestsEnabled = autoTestsEnabled;
        if (!this.autoTestsEnabled) {
            this.setTestCacheEnabled(false);
        }
    }

    public TestCaseExecutionType getTestCaseExecutionType() {
        return this.testCaseExecutionType;
    }

    public void setTestCaseExecutionType(TestCaseExecutionType testCaseExecutionType) {
        this.testCaseExecutionType = testCaseExecutionType;
    }

    public boolean isCalculateCoverageEnabled() {
        return this.calculateCoverageEnabled;
    }

    public void setCalculateCoverageEnabled(boolean calculateCoverageEnabled) {
        this.calculateCoverageEnabled = calculateCoverageEnabled;
    }

    public String getDataFolder() {
        return this.dataFolder;
    }

    public String getTestFolder() {
        return this.testFolder;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getDatasetURI() {
        return this.datasetURI;
    }

    public String getEndpointURI() {
        return this.testSourceBuilder.getSparqlEndpoint();
    }

    public Collection<String> getEndpointGraphs() {
        return this.testSourceBuilder.getEndpointGraphs();
    }

    public String getCustomDereferenceURI() {
        return this.customDereferenceURI;
    }

    public EnrichedSchemaSource getEnrichedSchema() {
        return this.enrichedSchema;
    }

    public Collection<SerializationFormat> getOutputFormats() {
        return this.outputFormats;
    }

    public SerializationFormat geFirstOutputFormat() {
        return RDFUnitUtils.getFirstItemInCollection(this.outputFormats);
    }

    public long getEndpointQueryDelayMS() {
        return this.endpointQueryDelayMS;
    }

    public void setEndpointQueryDelayMS(long endpointQueryDelayMS) {
        this.endpointQueryDelayMS = endpointQueryDelayMS;
    }

    public long getEndpointQueryCacheTTL() {
        return this.endpointQueryCacheTTL;
    }

    public void setEndpointQueryCacheTTL(long endpointQueryCacheTTL) {
        this.endpointQueryCacheTTL = endpointQueryCacheTTL;
    }

    public long getEndpointQueryPagination() {
        return this.endpointQueryPagination;
    }

    public void setEndpointQueryPagination(long endpointQueryPagination) {
        this.endpointQueryPagination = endpointQueryPagination;
    }

    public long getEndpointQueryLimit() {
        return this.endpointQueryLimit;
    }

    public void setEndpointQueryLimit(long endpointQueryLimit) {
        this.endpointQueryLimit = endpointQueryLimit;
    }
}

