/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.aksw.rdfunit.io.reader.RDFFirstSuccessReader;
import org.aksw.rdfunit.io.reader.RDFMultipleReader;
import org.aksw.rdfunit.io.reader.RDFReader;
import org.aksw.rdfunit.io.reader.RDFReaderException;
import org.aksw.rdfunit.io.reader.RDFReaderFactory;
import org.aksw.rdfunit.io.reader.RDFStreamReader;
import org.aksw.rdfunit.patterns.Pattern;
import org.aksw.rdfunit.services.PatternService;
import org.aksw.rdfunit.services.PrefixNSService;
import org.aksw.rdfunit.tests.TestAutoGenerator;
import org.aksw.rdfunit.utils.PatternUtils;
import org.aksw.rdfunit.utils.TestGeneratorUtils;

public class RDFUnit {
    private final Collection<String> baseDirectories;
    private volatile Collection<TestAutoGenerator> autoGenerators;
    private volatile Collection<Pattern> patterns;
    private volatile QueryExecutionFactory patternQueryFactory;

    public RDFUnit(Collection<String> baseDirectories) {
        this.baseDirectories = baseDirectories;
    }

    public RDFUnit(String baseDirectory) {
        this(Arrays.asList(baseDirectory));
    }

    public RDFUnit() {
        this(new ArrayList<String>());
    }

    public void init() throws RDFReaderException {
        Model model = ModelFactory.createDefaultModel();
        PrefixNSService.setNSPrefixesInModel(model);
        try {
            RDFUnit.getPatternsReader(this.baseDirectories).read(model);
            RDFUnit.getAutoGeneratorsALLReader(this.baseDirectories).read(model);
        }
        catch (RDFReaderException e) {
            throw new RDFReaderException(e.getMessage(), e);
        }
        this.patternQueryFactory = new QueryExecutionFactoryModel(model);
        for (Pattern pattern : this.getPatterns()) {
            PatternService.addPattern(pattern.getId(), pattern);
        }
    }

    private synchronized Collection<Pattern> getPatterns() {
        if (this.patterns == null) {
            this.patterns = Collections.unmodifiableCollection(PatternUtils.instantiatePatternsFromModel(this.patternQueryFactory));
        }
        return this.patterns;
    }

    public synchronized Collection<TestAutoGenerator> getAutoGenerators() {
        if (this.autoGenerators == null) {
            this.autoGenerators = Collections.unmodifiableCollection(TestGeneratorUtils.instantiateTestGeneratorsFromModel(this.patternQueryFactory));
        }
        return this.autoGenerators;
    }

    private static RDFReader createReaderFromBaseDirsAndResource(Collection<String> baseDirectories, String relativeName) {
        ArrayList<RDFReader> readers = new ArrayList<RDFReader>();
        for (String baseDirectory : baseDirectories) {
            String normalizedBaseDir = baseDirectory.endsWith("/") ? baseDirectory : baseDirectory + "/";
            readers.add(new RDFStreamReader(normalizedBaseDir + relativeName));
        }
        readers.add(RDFReaderFactory.createResourceReader("/org/aksw/rdfunit/" + relativeName));
        return new RDFFirstSuccessReader(readers);
    }

    public static RDFReader getPatternsReader(Collection<String> baseDirectories) {
        return RDFUnit.createReaderFromBaseDirsAndResource(baseDirectories, "patterns.ttl");
    }

    public static RDFReader getPatternsReader() {
        return RDFUnit.getPatternsReader(new ArrayList<String>());
    }

    public static RDFReader getAutoGeneratorsOWLReader(Collection<String> baseDirectories) {
        return RDFUnit.createReaderFromBaseDirsAndResource(baseDirectories, "autoGeneratorsOWL.ttl");
    }

    public static RDFReader getAutoGeneratorsOWLReader() {
        return RDFUnit.getAutoGeneratorsOWLReader(new ArrayList<String>());
    }

    public static RDFReader getAutoGeneratorsDSPReader(Collection<String> baseDirectories) {
        return RDFUnit.createReaderFromBaseDirsAndResource(baseDirectories, "autoGeneratorsDSP.ttl");
    }

    public static RDFReader getAutoGeneratorsDSPReader() {
        return RDFUnit.getAutoGeneratorsDSPReader(new ArrayList<String>());
    }

    public static RDFReader getAutoGeneratorsRSReader(Collection<String> baseDirectories) {
        return RDFUnit.createReaderFromBaseDirsAndResource(baseDirectories, "autoGeneratorsRS.ttl");
    }

    public static RDFReader getAutoGeneratorsRSReader() {
        return RDFUnit.getAutoGeneratorsRSReader(new ArrayList<String>());
    }

    public static RDFReader getAutoGeneratorsALLReader(Collection<String> baseDirectories) {
        List<RDFReader> readers = Arrays.asList(RDFUnit.getAutoGeneratorsOWLReader(baseDirectories), RDFUnit.getAutoGeneratorsDSPReader(baseDirectories), RDFUnit.getAutoGeneratorsRSReader(baseDirectories));
        return new RDFMultipleReader(readers);
    }

    public static RDFReader getAutoGeneratorsALLReader() {
        return RDFUnit.getAutoGeneratorsALLReader(new ArrayList<String>());
    }
}

