/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.results;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.rdfunit.enums.RLOGLevel;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.results.RLOGTestCaseResult;
import org.aksw.rdfunit.tests.results.ResultAnnotation;
import org.aksw.rdfunit.utils.PrefixNSService;

public class ExtendedTestCaseResult
extends RLOGTestCaseResult {
    private final Map<ResultAnnotation, Set<RDFNode>> variableAnnotationsMap = this.createMap();

    public ExtendedTestCaseResult(TestCase testCase, RLOGTestCaseResult rlogResult) {
        this(testCase, rlogResult.getResource(), rlogResult.getMessage(), rlogResult.getLogLevel());
    }

    public ExtendedTestCaseResult(TestCase testCase, String resource, String message, RLOGLevel logLevel) {
        super(testCase, resource, message, logLevel);
    }

    @Override
    public Resource serialize(Model model, String testExecutionURI) {
        Resource resource = super.serialize(model, testExecutionURI).addProperty(RDF.type, (RDFNode)model.createResource(PrefixNSService.getURIFromAbbrev((String)"rut:ExtendedTestCaseResult"))).addProperty(RDF.type, (RDFNode)model.createResource(PrefixNSService.getURIFromAbbrev((String)"spin:ConstraintViolation"))).addProperty(model.createProperty(PrefixNSService.getURIFromAbbrev((String)"spin:violationRoot")), (RDFNode)model.createResource(this.getResource()));
        for (Map.Entry<ResultAnnotation, Set<RDFNode>> vaEntry : this.variableAnnotationsMap.entrySet()) {
            for (RDFNode rdfNode : vaEntry.getValue()) {
                resource.addProperty(ResourceFactory.createProperty((String)vaEntry.getKey().getAnnotationProperty()), rdfNode);
            }
        }
        return resource;
    }

    public Map<ResultAnnotation, Set<RDFNode>> getVariableAnnotationsMap() {
        return this.variableAnnotationsMap;
    }

    private Map<ResultAnnotation, Set<RDFNode>> createMap() {
        HashMap vaMap = new HashMap();
        Collection<ResultAnnotation> variableAnnotations = this.getTestCase().getVariableAnnotations();
        for (ResultAnnotation annotation : variableAnnotations) {
            vaMap.put(annotation, new HashSet());
        }
        return Collections.unmodifiableMap(vaMap);
    }
}

