/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.query_generation;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import java.util.HashSet;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.query_generation.QueryGenerationFactory;
import org.aksw.rdfunit.tests.results.ResultAnnotation;
import org.aksw.rdfunit.utils.PrefixNSService;

public class QueryGenerationExtendedSelectFactory
implements QueryGenerationFactory {
    private static final String selectDistinctResource = " SELECT DISTINCT ?resource ";
    private static final String resourceVar = "?resource";
    private static final String whereClause = " WHERE ";
    private static final String orderByResourceAsc = "  ORDER BY ASC(?resource) ";

    @Override
    public String getSparqlQueryAsString(TestCase testCase) {
        StringBuilder sb = new StringBuilder();
        sb.append(PrefixNSService.getSparqlPrefixDecl());
        sb.append(selectDistinctResource);
        HashSet<String> existingVariables = new HashSet<String>();
        existingVariables.add(resourceVar);
        for (ResultAnnotation annotation : testCase.getVariableAnnotations()) {
            String value = annotation.getAnnotationValue().toString().trim();
            if (existingVariables.contains(value)) continue;
            sb.append(" ");
            sb.append(value);
            sb.append(" ");
            existingVariables.add(value);
        }
        sb.append(whereClause);
        sb.append(testCase.getSparqlWhere());
        sb.append(orderByResourceAsc);
        return sb.toString();
    }

    @Override
    public Query getSparqlQuery(TestCase testCase) {
        return QueryFactory.create((String)this.getSparqlQueryAsString(testCase));
    }
}

