/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.query_generation;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.query_generation.QueryGenerationFactory;
import org.aksw.rdfunit.utils.PrefixNSService;

public class QueryGenerationCountFactory
implements QueryGenerationFactory {
    private static final String selectClauseSimple = " SELECT (count(DISTINCT ?resource ) AS ?total ) WHERE ";
    private static final String selectClauseGroupStart = " SELECT (count(DISTINCT ?resource ) AS ?total ) WHERE { SELECT ?resource WHERE ";
    private static final String selectClauseGroupEnd = "}";

    @Override
    public String getSparqlQueryAsString(TestCase testCase) {
        return this.getSparqlQuery(testCase).toString();
    }

    @Override
    public Query getSparqlQuery(TestCase testCase) {
        Query query = QueryFactory.create((String)(PrefixNSService.getSparqlPrefixDecl() + selectClauseSimple + testCase.getSparqlWhere()));
        if (!query.hasGroupBy()) {
            return query;
        }
        query = QueryFactory.create((String)(PrefixNSService.getSparqlPrefixDecl() + selectClauseGroupStart + testCase.getSparqlWhere() + selectClauseGroupEnd));
        return query;
    }
}

