/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.generators;

import java.util.ArrayList;
import java.util.Collection;
import org.aksw.rdfunit.Utils.CacheUtils;
import org.aksw.rdfunit.Utils.TestGeneratorUtils;
import org.aksw.rdfunit.Utils.TestUtils;
import org.aksw.rdfunit.enums.TestGenerationType;
import org.aksw.rdfunit.io.reader.RDFReaderException;
import org.aksw.rdfunit.io.reader.RDFReaderFactory;
import org.aksw.rdfunit.io.reader.RDFStreamReader;
import org.aksw.rdfunit.io.writer.RDFFileWriter;
import org.aksw.rdfunit.io.writer.RDFWriter;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.tests.TestAutoGenerator;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.TestSuite;
import org.aksw.rdfunit.tests.generators.monitors.TestGeneratorExecutorMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGeneratorExecutor {
    private static final Logger log = LoggerFactory.getLogger(TestGeneratorExecutor.class);
    private volatile boolean isCanceled = false;
    private final boolean loadFromCache;
    private final boolean useManualTests;
    private final boolean useAutoTests;
    private final Collection<TestGeneratorExecutorMonitor> progressMonitors = new ArrayList<TestGeneratorExecutorMonitor>();

    public TestGeneratorExecutor() {
        this(true, true, true);
    }

    public TestGeneratorExecutor(boolean useAutoTests, boolean loadFromCache, boolean useManualTests) {
        this.useAutoTests = useAutoTests;
        this.loadFromCache = loadFromCache;
        this.useManualTests = useManualTests;
        assert (useAutoTests || useManualTests);
        assert (useAutoTests || !loadFromCache);
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public TestSuite generateTestSuite(String testFolder, Source dataset, Collection<TestAutoGenerator> autoGenerators) {
        Collection<SchemaSource> sources = dataset.getReferencesSchemata();
        for (TestGeneratorExecutorMonitor monitor : this.progressMonitors) {
            monitor.generationStarted(dataset, sources.size());
        }
        ArrayList<TestCase> allTests = new ArrayList<TestCase>();
        for (SchemaSource s : sources) {
            if (this.isCanceled) break;
            log.info("Generating tests for: {}", (Object)s.getUri());
            if (this.useAutoTests) {
                allTests.addAll(this.generateAutoTestsForSchemaSource(testFolder, s, autoGenerators));
            }
            if (!this.useManualTests) continue;
            allTests.addAll(this.generateManualTestsForSource(testFolder, s));
        }
        if (!this.isCanceled && this.useManualTests) {
            allTests.addAll(this.generateManualTestsForSource(testFolder, dataset));
        }
        for (TestGeneratorExecutorMonitor monitor : this.progressMonitors) {
            monitor.generationFinished();
        }
        return new TestSuite(allTests);
    }

    private Collection<TestCase> generateAutoTestsForSchemaSource(String testFolder, SchemaSource s, Collection<TestAutoGenerator> autoGenerators) {
        ArrayList<TestCase> tests = new ArrayList<TestCase>();
        for (TestGeneratorExecutorMonitor monitor : this.progressMonitors) {
            monitor.sourceGenerationStarted(s, TestGenerationType.AutoGenerated);
        }
        try {
            String cachedTestsLocation = CacheUtils.getSourceAutoTestFile(testFolder, s);
            if (!this.loadFromCache) {
                cachedTestsLocation = "";
            }
            Collection<TestCase> testsAutoCached = TestUtils.instantiateTestsFromModel(new RDFStreamReader(cachedTestsLocation).read());
            tests.addAll(testsAutoCached);
            log.info("{} contains {} automatically created tests (loaded from cache)", (Object)s.getUri(), (Object)testsAutoCached.size());
        }
        catch (RDFReaderException e) {
            Collection<TestCase> testsAuto = TestGeneratorUtils.instantiateTestsFromAG(autoGenerators, s);
            tests.addAll(testsAuto);
            TestUtils.writeTestsToFile(testsAuto, (RDFWriter)new RDFFileWriter(CacheUtils.getSourceAutoTestFile(testFolder, s)));
            log.info("{} contains {} automatically created tests", (Object)s.getUri(), (Object)testsAuto.size());
        }
        for (TestGeneratorExecutorMonitor monitor : this.progressMonitors) {
            monitor.sourceGenerationExecuted(s, TestGenerationType.AutoGenerated, tests.size());
        }
        return tests;
    }

    private Collection<TestCase> generateManualTestsForSource(String testFolder, Source s) {
        ArrayList<TestCase> tests = new ArrayList<TestCase>();
        for (TestGeneratorExecutorMonitor monitor : this.progressMonitors) {
            monitor.sourceGenerationStarted(s, TestGenerationType.ManuallyGenerated);
        }
        try {
            Collection<TestCase> testsManuals = TestUtils.instantiateTestsFromModel(RDFReaderFactory.createFileOrResourceReader((String)CacheUtils.getSourceManualTestFile(testFolder, s), (String)CacheUtils.getSourceManualTestFile("/org/aksw/rdfunit/tests/", s)).read());
            tests.addAll(testsManuals);
            log.info("{} contains {} manually created tests", (Object)s.getUri(), (Object)testsManuals.size());
        }
        catch (RDFReaderException rDFReaderException) {
            // empty catch block
        }
        for (TestGeneratorExecutorMonitor monitor : this.progressMonitors) {
            monitor.sourceGenerationExecuted(s, TestGenerationType.ManuallyGenerated, tests.size());
        }
        return tests;
    }

    public void addTestExecutorMonitor(TestGeneratorExecutorMonitor monitor) {
        if (!this.progressMonitors.contains(monitor)) {
            this.progressMonitors.add(monitor);
        }
    }

    public void removeTestExecutorMonitor(TestGeneratorExecutorMonitor monitor) {
        this.progressMonitors.remove(monitor);
    }
}

