/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.executors.monitors;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.uuid.JenaUUID;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Collection;
import org.aksw.rdfunit.Utils.RDFUnitUtils;
import org.aksw.rdfunit.enums.TestCaseExecutionType;
import org.aksw.rdfunit.enums.TestCaseResultStatus;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.sources.TestSource;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.TestSuite;
import org.aksw.rdfunit.tests.executors.monitors.TestExecutorMonitor;
import org.aksw.rdfunit.tests.results.AggregatedTestCaseResult;
import org.aksw.rdfunit.tests.results.DatasetOverviewResults;
import org.aksw.rdfunit.tests.results.StatusTestCaseResult;
import org.aksw.rdfunit.tests.results.TestCaseResult;
import org.aksw.rdfunit.utils.PrefixNSService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTestExecutorMonitor
implements TestExecutorMonitor {
    private static final Logger log = LoggerFactory.getLogger(SimpleTestExecutorMonitor.class);
    private final boolean loggingEnabled;
    private final DatasetOverviewResults overviewResults = new DatasetOverviewResults();
    private final Model model;
    private final String executionUUID;
    private Source testedDataset;
    private TestSuite testSuite;
    private TestCaseExecutionType executionType;
    private String userID = "http://localhost/";
    private long counter = 0L;

    public SimpleTestExecutorMonitor() {
        this(ModelFactory.createDefaultModel(), true);
    }

    public SimpleTestExecutorMonitor(boolean loggingEnabled) {
        this(ModelFactory.createDefaultModel(), loggingEnabled);
    }

    public SimpleTestExecutorMonitor(Model model) {
        this(model, true);
    }

    public SimpleTestExecutorMonitor(Model model, boolean loggingEnabled) {
        this.model = model;
        this.loggingEnabled = loggingEnabled;
        PrefixNSService.setNSPrefixesInModel((Model)model);
        this.executionUUID = PrefixNSService.getURIFromAbbrev((String)("rutr:" + JenaUUID.generate().asString()));
    }

    @Override
    public void testingStarted(TestSource testSource, TestSuite testSuite) {
        this.testedDataset = testSource;
        this.testSuite = testSuite;
        this.counter = 0L;
        this.overviewResults.reset();
        this.overviewResults.setStartTime();
        this.overviewResults.setTotalTests(testSuite.size());
        if (this.loggingEnabled) {
            log.info("Testing {}", (Object)this.testedDataset.getUri());
        }
    }

    @Override
    public void singleTestStarted(TestCase test) {
        ++this.counter;
    }

    @Override
    public void singleTestExecuted(TestCase test, TestCaseResultStatus status, Collection<TestCaseResult> results) {
        if (status.equals((Object)TestCaseResultStatus.Error)) {
            this.overviewResults.increaseErrorTests();
        }
        if (status.equals((Object)TestCaseResultStatus.Timeout)) {
            this.overviewResults.increaseTimeoutTests();
        }
        if (status.equals((Object)TestCaseResultStatus.Success)) {
            this.overviewResults.increaseSuccessfullTests();
        }
        if (status.equals((Object)TestCaseResultStatus.Fail)) {
            this.overviewResults.increaseFailedTests();
        }
        for (TestCaseResult result : results) {
            result.serialize(this.getModel(), this.executionUUID);
        }
        boolean statusResult = false;
        if (results.size() == 1) {
            TestCaseResult result;
            result = RDFUnitUtils.getFirstItemInCollection(results);
            assert (result != null);
            if (result instanceof StatusTestCaseResult) {
                long errorCount;
                statusResult = true;
                if (this.loggingEnabled) {
                    log.info("Test " + this.counter + "/" + this.overviewResults.getTotalTests() + " returned " + result);
                }
                if (result instanceof AggregatedTestCaseResult && (errorCount = ((AggregatedTestCaseResult)result).getErrorCount()) > 0L) {
                    long individualErrors = ((AggregatedTestCaseResult)result).getErrorCount();
                    this.overviewResults.increaseIndividualErrors(individualErrors);
                }
            }
        }
        if (!statusResult) {
            long individualErrors = results.size();
            this.overviewResults.increaseIndividualErrors(individualErrors);
            if (this.loggingEnabled) {
                log.info("Test " + this.counter + "/" + this.overviewResults.getTotalTests() + " returned " + results.size() + " violation instances / TC: " + test.getAbrTestURI());
            }
        }
    }

    @Override
    public void testingFinished() {
        this.overviewResults.setEndTime();
        Resource testSuiteResource = this.testSuite.serialize(this.getModel());
        Resource execution = this.getModel().createResource(this.executionUUID);
        execution.addProperty(RDF.type, (RDFNode)this.getModel().createResource(PrefixNSService.getURIFromAbbrev((String)"rut:TestExecution"))).addProperty(RDF.type, (RDFNode)this.getModel().createResource(PrefixNSService.getURIFromAbbrev((String)"prov:Activity"))).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"prov:used")), (RDFNode)testSuiteResource).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"prov:startedAtTime")), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.overviewResults.getStartTime()), (RDFDatatype)XSDDatatype.XSDdateTime)).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"prov:endedAtTime")), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.overviewResults.getEndTime()), (RDFDatatype)XSDDatatype.XSDdateTime)).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"rut:source")), (RDFNode)this.getModel().createResource(this.testedDataset.getUri())).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"rut:testsRun")), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.overviewResults.getTotalTests()), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger)).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"rut:testsSuceedded")), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.overviewResults.getSuccessfullTests()), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger)).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"rut:testsFailed")), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.overviewResults.getFailedTests()), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger)).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"rut:testsTimeout")), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.overviewResults.getTimeoutTests()), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger)).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"rut:testsError")), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.overviewResults.getErrorTests()), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger)).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"rut:totalIndividualErrors")), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.overviewResults.getIndividualErrors()), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger)).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"prov:wasStartedBy")), (RDFNode)this.getModel().createResource(this.userID));
        for (SchemaSource src : this.testedDataset.getReferencesSchemata()) {
            execution.addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"prov:wasAssociatedWith")), (RDFNode)this.getModel().createResource(src.getUri()));
        }
        if (this.executionType != null) {
            execution.addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"rut:executionType")), this.executionType.name());
        }
        if (this.loggingEnabled) {
            log.info("Tests run: " + this.overviewResults.getTotalTests() + ", Failed: " + this.overviewResults.getFailedTests() + ", Timeout: " + this.overviewResults.getTimeoutTests() + ", Error: " + this.overviewResults.getErrorTests() + ". Individual Errors: " + this.overviewResults.getIndividualErrors());
        }
    }

    public Model getModel() {
        return this.model;
    }

    public DatasetOverviewResults getOverviewResults() {
        return this.overviewResults;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public void setExecutionType(TestCaseExecutionType executionType) {
        this.executionType = executionType;
    }
}

