/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.executors;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.engine.http.QueryExceptionHTTP;
import java.util.ArrayList;
import java.util.Collection;
import org.aksw.rdfunit.Utils.SparqlUtils;
import org.aksw.rdfunit.enums.RLOGLevel;
import org.aksw.rdfunit.enums.TestCaseResultStatus;
import org.aksw.rdfunit.exceptions.TestCaseExecutionException;
import org.aksw.rdfunit.sources.TestSource;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.executors.TestExecutor;
import org.aksw.rdfunit.tests.query_generation.QueryGenerationFactory;
import org.aksw.rdfunit.tests.results.RLOGTestCaseResult;
import org.aksw.rdfunit.tests.results.TestCaseResult;
import org.aksw.rdfunit.utils.StringUtils;

public class RLOGTestExecutor
extends TestExecutor {
    public RLOGTestExecutor(QueryGenerationFactory queryGenerationFactory) {
        super(queryGenerationFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<TestCaseResult> executeSingleTest(TestSource testSource, TestCase testCase) throws TestCaseExecutionException {
        ArrayList<TestCaseResult> testCaseResults = new ArrayList<TestCaseResult>();
        try (QueryExecution qe = null;){
            qe = testSource.getExecutionFactory().createQueryExecution(this.queryGenerationFactory.getSparqlQuery(testCase));
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.next();
                String resource = qs.get("resource").toString();
                if (qs.get("resource").isLiteral()) {
                    resource = StringUtils.getHashFromString((String)resource);
                }
                String message = testCase.getResultMessage();
                if (qs.contains("message")) {
                    message = qs.get("message").toString();
                }
                RLOGLevel logLevel = testCase.getLogLevel();
                testCaseResults.add(new RLOGTestCaseResult(testCase, resource, message, logLevel));
            }
        }
        return testCaseResults;
    }

    protected void checkQueryResultStatus(QueryExceptionHTTP e) throws TestCaseExecutionException {
        if (SparqlUtils.checkStatusForTimeout(e)) {
            throw new TestCaseExecutionException(TestCaseResultStatus.Timeout, (Throwable)e);
        }
        throw new TestCaseExecutionException(TestCaseResultStatus.Error, (Throwable)e);
    }
}

