/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests;

import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import java.util.List;
import org.aksw.rdfunit.exceptions.TestCaseInstantiationException;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.query_generation.QueryGenerationAskFactory;
import org.aksw.rdfunit.tests.query_generation.QueryGenerationCountFactory;
import org.aksw.rdfunit.tests.query_generation.QueryGenerationExtendedSelectFactory;
import org.aksw.rdfunit.tests.query_generation.QueryGenerationSelectFactory;
import org.aksw.rdfunit.utils.PrefixNSService;

public class TestCaseValidator {
    private final TestCase testCase;

    public TestCaseValidator(TestCase testCase) {
        this.testCase = testCase;
    }

    public void validate() throws TestCaseInstantiationException {
        this.validateSPARQL(new QueryGenerationSelectFactory().getSparqlQueryAsString(this.testCase), "SPARQL");
        this.validateSPARQL(new QueryGenerationExtendedSelectFactory().getSparqlQueryAsString(this.testCase), "SPARQL Extended");
        this.validateSPARQL(new QueryGenerationCountFactory().getSparqlQueryAsString(this.testCase), "SPARQL Count");
        this.validateSPARQL(new QueryGenerationAskFactory().getSparqlQueryAsString(this.testCase), "ASK");
        if (!this.testCase.getSparqlPrevalence().trim().isEmpty()) {
            this.validateSPARQL(PrefixNSService.getSparqlPrefixDecl() + this.testCase.getSparqlPrevalence(), "prevalence");
        }
        List vars = new QueryGenerationSelectFactory().getSparqlQuery(this.testCase).getResultVars();
        boolean hasResource = false;
        for (String v : vars) {
            if (!"resource".equals(v)) continue;
            hasResource = true;
        }
        if (!hasResource) {
            throw new TestCaseInstantiationException("?resource is not included in SELECT for Test: " + this.testCase.getTestURI());
        }
        if (this.testCase.getResultMessage().trim().isEmpty()) {
            throw new TestCaseInstantiationException("No test case dcterms:description message included in TestCase: " + this.testCase.getTestURI());
        }
        if (this.testCase.getLogLevel() == null) {
            throw new TestCaseInstantiationException("No (or malformed) log level included for Test: " + this.testCase.getTestURI());
        }
    }

    private void validateSPARQL(String sparql, String type) throws TestCaseInstantiationException {
        try {
            QueryFactory.create((String)sparql);
        }
        catch (QueryParseException e) {
            String message = "QueryParseException in " + type + " query (line " + e.getLine() + ", column " + e.getColumn() + " for Test: " + this.testCase.getTestURI() + "\n" + PrefixNSService.getSparqlPrefixDecl() + sparql;
            throw new TestCaseInstantiationException(message, e);
        }
    }
}

