/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aksw.rdfunit.Utils.TestUtils;
import org.aksw.rdfunit.enums.TestGenerationType;
import org.aksw.rdfunit.exceptions.BindingException;
import org.aksw.rdfunit.exceptions.TestCaseInstantiationException;
import org.aksw.rdfunit.patterns.Pattern;
import org.aksw.rdfunit.patterns.PatternParameter;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.tests.Binding;
import org.aksw.rdfunit.tests.PatternBasedTestCase;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.TestCaseAnnotation;
import org.aksw.rdfunit.tests.TestCaseValidator;
import org.aksw.rdfunit.tests.results.ResultAnnotation;
import org.aksw.rdfunit.utils.PrefixNSService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAutoGenerator {
    private static final Logger log = LoggerFactory.getLogger(TestAutoGenerator.class);
    private final String uri;
    private final String description;
    private final String query;
    private final Pattern pattern;
    private final Collection<ResultAnnotation> generatorAnnotations;

    public TestAutoGenerator(String uri, String description, String query, Pattern pattern, Collection<ResultAnnotation> generatorAnnotations) {
        this.uri = uri;
        this.description = description;
        this.query = query;
        this.pattern = pattern;
        this.generatorAnnotations = generatorAnnotations;
    }

    public boolean isValid() {
        Query q;
        if (this.pattern == null) {
            log.error("{} : Pattern {} does not exist", (Object)this.getUri(), (Object)this.getPattern());
            return false;
        }
        try {
            q = QueryFactory.create((String)(PrefixNSService.getSparqlPrefixDecl() + this.getQuery()));
        }
        catch (Exception e) {
            log.error("{} Cannot parse query:\n{}", new Object[]{this.getUri(), PrefixNSService.getSparqlPrefixDecl() + this.getQuery(), e});
            return false;
        }
        List sv = q.getProjectVars();
        if (sv.size() != this.pattern.getParameters().size() + 1) {
            log.error("{} Select variables are different than Pattern parameters", (Object)this.getUri());
            return false;
        }
        return true;
    }

    public Collection<TestCase> generate(Source source) {
        ArrayList<TestCase> tests = new ArrayList<TestCase>();
        Query q = QueryFactory.create((String)(PrefixNSService.getSparqlPrefixDecl() + this.getQuery()));
        QueryExecution qe = source.getExecutionFactory().createQueryExecution(q);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            QuerySolution row = rs.next();
            ArrayList<Binding> bindings = new ArrayList<Binding>();
            ArrayList<String> references = new ArrayList<String>();
            for (PatternParameter p : this.pattern.getParameters()) {
                if (row.contains(p.getId())) {
                    Binding b;
                    RDFNode n = row.get(p.getId());
                    try {
                        b = new Binding(p, n);
                    }
                    catch (BindingException e) {
                        log.error("Non valid binding for parameter {} in AutoGenerator: {}", new Object[]{p.getId(), this.getUri(), e});
                        continue;
                    }
                    bindings.add(b);
                    if (!n.isResource() || "loglevel".equalsIgnoreCase(p.getId())) continue;
                    references.add(n.toString().trim().replace(" ", ""));
                    continue;
                }
                log.error("Not bindings for parameter {} in AutoGenerator: {}", (Object)p.getId(), (Object)this.getUri());
                break;
            }
            if (bindings.size() != this.getPattern().getParameters().size()) {
                log.error("Bindings for pattern {} do not match in AutoGenerator: {}", (Object)this.pattern.getId(), (Object)this.getUri());
                continue;
            }
            if (row.get("DESCRIPTION") == null) {
                log.error("No ?DESCRIPTION variable found in AutoGenerator: {}", (Object)this.getUri());
                continue;
            }
            String description = row.get("DESCRIPTION").toString();
            try {
                Collection<ResultAnnotation> patternBindedAnnotations = this.pattern.getBindedAnnotations(bindings);
                patternBindedAnnotations.addAll(this.generatorAnnotations);
                PatternBasedTestCase tc = new PatternBasedTestCase(TestUtils.generateTestURI(source.getPrefix(), this.getPattern(), bindings, this.uri), new TestCaseAnnotation(TestGenerationType.AutoGenerated, this.getUri(), source.getSourceType(), source.getUri(), references, description, null, patternBindedAnnotations), this.pattern, bindings);
                new TestCaseValidator(tc).validate();
                tests.add(tc);
            }
            catch (TestCaseInstantiationException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return tests;
    }

    public String getUri() {
        return this.uri;
    }

    public String getDescription() {
        return this.description;
    }

    public String getQuery() {
        return this.query;
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

