/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import org.aksw.rdfunit.exceptions.TestCaseInstantiationException;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.TestCaseAnnotation;
import org.aksw.rdfunit.utils.PrefixNSService;

public class ManualTestCase
extends TestCase {
    private final String sparqlWhere;
    private final String sparqlPrevalence;

    public ManualTestCase(String testURI, TestCaseAnnotation annotation, String sparqlWhere, String sparqlPrevalence) throws TestCaseInstantiationException {
        super(testURI, annotation);
        this.sparqlWhere = sparqlWhere.trim();
        this.sparqlPrevalence = sparqlPrevalence.trim();
    }

    @Override
    public Resource serialize(Model model) {
        Resource resource = super.serialize(model);
        resource.addProperty(RDF.type, (RDFNode)model.createResource(PrefixNSService.getURIFromAbbrev((String)"rut:ManualTestCase"))).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"rut:sparqlWhere")), this.getSparqlWhere()).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"rut:sparqlPrevalence")), this.getSparqlPrevalence());
        return resource;
    }

    @Override
    public String getSparqlWhere() {
        return this.sparqlWhere;
    }

    @Override
    public String getSparqlPrevalence() {
        return this.sparqlPrevalence;
    }
}

