/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import java.util.Collection;
import org.aksw.jena_sparql_api.cache.h2.CacheUtilsH2;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.delay.core.QueryExecutionFactoryDelay;
import org.aksw.jena_sparql_api.limit.QueryExecutionFactoryLimit;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionFactoryPaginated;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.Source;

public abstract class TestSource
extends Source {
    public static final long CACHE_TTL = 604800000L;
    public static final long PAGINATION = 800L;
    public static final long QUERY_DELAY = 5000L;
    public static final long QUERY_LIMIT = 799L;
    protected long cacheTTL = 604800000L;
    protected long queryDelay = 5000L;
    protected long queryLimit = 799L;
    protected long pagination = 800L;

    public TestSource(String prefix, String uri) {
        super(prefix, uri);
    }

    public TestSource(Source source) {
        super(source);
    }

    public TestSource(TestSource source, Collection<SchemaSource> referencesSchemata) {
        super(source);
        this.addReferencesSchemata(referencesSchemata);
        this.cacheTTL = source.cacheTTL;
        this.queryDelay = source.queryDelay;
        this.queryLimit = source.queryLimit;
        this.pagination = source.pagination;
    }

    protected QueryExecutionFactory masqueradeQEF(QueryExecutionFactory originalQEF) {
        QueryExecutionFactory qef = originalQEF;
        if (this.queryDelay > 0L) {
            qef = new QueryExecutionFactoryDelay(qef, this.queryDelay);
        }
        if (this.cacheTTL > 0L) {
            try {
                qef = CacheUtilsH2.createQueryExecutionFactory((QueryExecutionFactory)qef, (String)("./cache/sparql/" + this.getPrefix()), (boolean)false, (long)this.cacheTTL);
                log.debug("Cache for endpoint set up: " + this.getUri());
            }
            catch (Exception e) {
                log.debug("Could not instantiate cache for Endpoint" + this.getUri(), (Throwable)e);
            }
        }
        if (this.pagination > 0L) {
            qef = new QueryExecutionFactoryPaginated(qef, this.pagination);
        }
        if (this.queryLimit > 0L) {
            qef = new QueryExecutionFactoryLimit(qef, true, Long.valueOf(this.queryLimit));
        }
        return qef;
    }

    public void setCacheTTL(long cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public void setQueryDelay(long queryDelay) {
        this.queryDelay = queryDelay;
    }

    public void setQueryLimit(long queryLimit) {
        this.queryLimit = queryLimit;
    }

    public void setPagination(long pagination) {
        this.pagination = pagination;
    }

    public long getCacheTTL() {
        return this.cacheTTL;
    }

    public long getQueryDelay() {
        return this.queryDelay;
    }

    public long getQueryLimit() {
        return this.queryLimit;
    }

    public long getPagination() {
        return this.pagination;
    }
}

