/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.enums.TestAppliesTo;
import org.aksw.rdfunit.sources.SchemaSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Source
implements Comparable<Source> {
    protected static final Logger log = LoggerFactory.getLogger(Source.class);
    private final String prefix;
    private final String uri;
    private final Set<SchemaSource> referencesSchemata;
    private QueryExecutionFactory queryFactory = null;

    public Source(String prefix, String uri) {
        this.prefix = prefix;
        this.uri = uri;
        this.referencesSchemata = new LinkedHashSet<SchemaSource>();
    }

    public Source(Source source) {
        this(source.getPrefix(), source.getUri());
        this.referencesSchemata.addAll(source.getReferencesSchemata());
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUri() {
        return this.uri;
    }

    public abstract TestAppliesTo getSourceType();

    protected abstract QueryExecutionFactory initQueryFactory();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Source)) {
            return false;
        }
        Source source = (Source)o;
        return this.uri.equals(source.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public QueryExecutionFactory getExecutionFactory() {
        if (this.queryFactory == null) {
            this.queryFactory = this.initQueryFactory();
        }
        return this.queryFactory;
    }

    public Collection<SchemaSource> getReferencesSchemata() {
        return this.referencesSchemata;
    }

    public void addReferencesSchemata(Collection<SchemaSource> schemata) {
        this.referencesSchemata.addAll(schemata);
    }

    @Override
    public int compareTo(Source o) {
        if (o == null) {
            return -1;
        }
        return this.getUri().compareTo(o.getUri());
    }

    public String toString() {
        return this.getPrefix() + " (" + this.getUri() + ")";
    }
}

