/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.Collection;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.aksw.rdfunit.enums.TestAppliesTo;
import org.aksw.rdfunit.io.reader.RDFReader;
import org.aksw.rdfunit.io.reader.RDFReaderFactory;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.sources.TestSource;

public class DumpTestSource
extends TestSource {
    private final RDFReader dumpReader;
    private final OntModel dumpModel;

    public DumpTestSource(String prefix, String uri) {
        this(prefix, uri, RDFReaderFactory.createDereferenceReader((String)uri), null);
    }

    public DumpTestSource(String prefix, String uri, String location) {
        this(prefix, uri, location, null);
    }

    public DumpTestSource(String prefix, String uri, String location, Collection<SchemaSource> schemata) {
        this(prefix, uri, RDFReaderFactory.createDereferenceReader((String)location), schemata);
    }

    public DumpTestSource(DumpTestSource source, Collection<SchemaSource> referencesSchemata) {
        super(source);
        this.addReferencesSchemata(referencesSchemata);
        this.dumpReader = source.dumpReader;
        this.dumpModel = source.dumpModel;
        this.cacheTTL = source.cacheTTL;
        this.queryDelay = source.queryDelay;
        this.queryLimit = source.queryLimit;
        this.pagination = source.pagination;
    }

    public DumpTestSource(String prefix, String uri, RDFReader dumpReader, Collection<SchemaSource> schemata) {
        this(prefix, uri, dumpReader, schemata, OntModelSpec.OWL_DL_MEM);
    }

    public DumpTestSource(String prefix, String uri, RDFReader dumpReader, Collection<SchemaSource> schemata, OntModelSpec ontoSpec) {
        super(prefix, uri);
        this.cacheTTL = 0L;
        this.queryDelay = 0L;
        this.queryLimit = 0L;
        this.pagination = 0L;
        this.dumpReader = dumpReader;
        if (schemata != null) {
            this.addReferencesSchemata(schemata);
        }
        this.dumpModel = ModelFactory.createOntologyModel((OntModelSpec)ontoSpec, (Model)ModelFactory.createDefaultModel());
    }

    @Override
    public TestAppliesTo getSourceType() {
        return TestAppliesTo.Dataset;
    }

    @Override
    protected QueryExecutionFactory initQueryFactory() {
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.RDFS_MEM_RDFS_INF, (Model)ModelFactory.createDefaultModel());
        try {
            if (this.dumpModel.isEmpty()) {
                this.dumpReader.read((Model)this.dumpModel);
            }
            for (Source source : this.getReferencesSchemata()) {
                QueryExecutionFactory qef = source.getExecutionFactory();
                if (!(qef instanceof QueryExecutionFactoryModel)) continue;
                ontModel.add(((QueryExecutionFactoryModel)qef).getModel());
            }
            this.dumpModel.add((Model)ontModel);
        }
        catch (Exception e) {
            log.error("Cannot read dump URI: " + this.getUri() + " Reason: " + e.getMessage());
            throw new IllegalArgumentException("Cannot read dump URI: " + this.getUri() + " Reason: " + e.getMessage(), e);
        }
        return this.masqueradeQEF((QueryExecutionFactory)new QueryExecutionFactoryModel((Model)this.dumpModel));
    }
}

