/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.enums;

import org.aksw.rdfunit.utils.PrefixNSService;

public enum TestGenerationType {
    AutoGenerated,
    ManuallyGenerated;

    private static final String schemaPrefix = "rut";

    public String getUri() {
        return PrefixNSService.getNSFromPrefix((String)schemaPrefix) + this.name();
    }

    public String toString() {
        return this.getUri();
    }

    public static TestGenerationType resolve(String value) {
        String qName = PrefixNSService.getLocalName((String)value, (String)schemaPrefix);
        for (TestGenerationType type : TestGenerationType.values()) {
            if (!qName.equals(type.name())) continue;
            return type;
        }
        return null;
    }
}

