/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.enums;

import org.aksw.rdfunit.utils.PrefixNSService;

public enum TestCaseResultStatus {
    Success,
    Fail,
    Timeout,
    Error,
    Running;

    private static final String schemaPrefix = "rut";

    public String getUri() {
        return PrefixNSService.getNSFromPrefix((String)schemaPrefix) + "ResultStatus" + this.name();
    }

    public String toString() {
        return this.getUri();
    }

    public static TestCaseResultStatus resolve(String value) {
        String qName = PrefixNSService.getLocalName((String)value, (String)schemaPrefix).replace("ResultStatus", "");
        for (TestCaseResultStatus status : TestCaseResultStatus.values()) {
            if (!qName.equals(status.name())) continue;
            return status;
        }
        return null;
    }

    public static TestCaseResultStatus resolve(long value) {
        if (value == -2L) {
            return Error;
        }
        if (value == -1L) {
            return Timeout;
        }
        if (value == 0L) {
            return Success;
        }
        if (value > 0L) {
            return Fail;
        }
        return null;
    }
}

