/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.Utils;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.engine.http.QueryExceptionHTTP;
import java.util.ArrayList;
import java.util.Collection;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.tests.results.ResultAnnotation;
import org.aksw.rdfunit.utils.PrefixNSService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SparqlUtils {
    private static final Logger log = LoggerFactory.getLogger(SparqlUtils.class);

    private SparqlUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ResultAnnotation> getResultAnnotations(QueryExecutionFactory queryFactory, String uri) {
        ArrayList<ResultAnnotation> annotations = new ArrayList<ResultAnnotation>();
        String sparql = PrefixNSService.getSparqlPrefixDecl() + " SELECT ?annotationProperty ?annotationValue WHERE {" + " <" + uri + "> rut:resultAnnotation ?annotation . " + " ?annotation a rut:ResultAnnotation ; " + "   rut:annotationProperty ?annotationProperty ; " + "   rut:annotationValue ?annotationValue . } ";
        try (QueryExecution qe = null;){
            qe = queryFactory.createQueryExecution(sparql);
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.next();
                String annotationProperty = qs.get("annotationProperty").toString();
                RDFNode annotationValue = qs.get("annotationValue");
                annotations.add(new ResultAnnotation(annotationProperty, annotationValue));
            }
        }
        return annotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkAskQuery(QueryExecutionFactory qef, String askQuery) {
        try (QueryExecution qe = null;){
            qe = qef.createQueryExecution(askQuery);
            boolean bl = qe.execAsk();
            return bl;
        }
        return false;
    }

    public static boolean checkStatusForTimeout(QueryExceptionHTTP e) {
        int httpCode = e.getResponseCode();
        return httpCode == 408 || httpCode == 504 || httpCode == 524;
    }
}

