/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.Utils;

import java.io.OutputStream;
import org.aksw.rdfunit.enums.TestCaseExecutionType;
import org.aksw.rdfunit.io.format.FormatService;
import org.aksw.rdfunit.io.format.SerializationFormat;
import org.aksw.rdfunit.io.writer.RDFFileWriter;
import org.aksw.rdfunit.io.writer.RDFHTMLResultsAggregateWriter;
import org.aksw.rdfunit.io.writer.RDFHTMLResultsRlogWriter;
import org.aksw.rdfunit.io.writer.RDFHTMLResultsStatusWriter;
import org.aksw.rdfunit.io.writer.RDFHTMLResultsWriter;
import org.aksw.rdfunit.io.writer.RDFStreamWriter;
import org.aksw.rdfunit.io.writer.RDFWriter;

public final class RDFWriterFactory {
    private RDFWriterFactory() {
    }

    public static RDFWriter createWriterFromFormat(String filenameWithoutExtension, SerializationFormat serializationFormat, TestCaseExecutionType executionType) {
        if (serializationFormat.equals((Object)FormatService.getOutputFormat((String)"html"))) {
            return RDFWriterFactory.createHTMLWriter(executionType, filenameWithoutExtension + "." + serializationFormat.getExtension());
        }
        return new RDFFileWriter(filenameWithoutExtension + "." + serializationFormat.getExtension(), serializationFormat.getName());
    }

    public static RDFWriter createWriterFromFormat(OutputStream outputStream, SerializationFormat serializationFormat, TestCaseExecutionType executionType) {
        if (serializationFormat.equals((Object)FormatService.getOutputFormat((String)"html"))) {
            return RDFWriterFactory.createHTMLWriter(executionType, outputStream);
        }
        return new RDFStreamWriter(outputStream, serializationFormat.getName());
    }

    public static RDFHTMLResultsWriter createHTMLWriter(TestCaseExecutionType type, String filename) {
        switch (type) {
            case statusTestCaseResult: {
                return new RDFHTMLResultsStatusWriter(filename);
            }
            case aggregatedTestCaseResult: {
                return new RDFHTMLResultsAggregateWriter(filename);
            }
            case rlogTestCaseResult: {
                return new RDFHTMLResultsRlogWriter(filename);
            }
            case extendedTestCaseResult: {
                return new RDFHTMLResultsRlogWriter(filename);
            }
        }
        return null;
    }

    public static RDFHTMLResultsWriter createHTMLWriter(TestCaseExecutionType type, OutputStream outputStream) {
        switch (type) {
            case statusTestCaseResult: {
                return new RDFHTMLResultsStatusWriter(outputStream);
            }
            case aggregatedTestCaseResult: {
                return new RDFHTMLResultsAggregateWriter(outputStream);
            }
            case rlogTestCaseResult: {
                return new RDFHTMLResultsRlogWriter(outputStream);
            }
            case extendedTestCaseResult: {
                return new RDFHTMLResultsRlogWriter(outputStream);
            }
        }
        return null;
    }
}

