/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.Utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import org.aksw.rdfunit.services.SchemaService;
import org.aksw.rdfunit.utils.LOVEntry;
import org.aksw.rdfunit.utils.LOVUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RDFUnitUtils {
    private static final Logger log = LoggerFactory.getLogger(RDFUnitUtils.class);

    private RDFUnitUtils() {
    }

    public static void fillSchemaServiceFromFile(String additionalCSV) {
        try (FileInputStream inputStream = new FileInputStream(additionalCSV);){
            RDFUnitUtils.fillSchemaServiceFromFile(inputStream);
        }
        catch (IOException e) {
            log.error("File " + additionalCSV + " not fount!", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void fillSchemaServiceFromFile(InputStream additionalCSV) {
        int count = 0;
        if (additionalCSV != null) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(additionalCSV, "UTF-8"));){
                String line;
                block18: while ((line = in.readLine()) != null) {
                    if (line.startsWith("#") || line.trim().isEmpty()) continue;
                    ++count;
                    String[] parts = line.split(",");
                    switch (parts.length) {
                        case 2: {
                            SchemaService.addSchemaDecl(parts[0], parts[1]);
                            continue block18;
                        }
                        case 3: {
                            SchemaService.addSchemaDecl(parts[0], parts[1], parts[2]);
                            continue block18;
                        }
                    }
                    log.error("Invalid schema declaration in " + additionalCSV + ". Line: " + line);
                    --count;
                }
            }
            catch (UnsupportedEncodingException e) {
                log.debug("UnsupportedEncodingException: ", (Throwable)e);
                return;
            }
            catch (IOException e) {
                log.debug("IOException: ", (Throwable)e);
            }
            log.info("Loaded " + count + " schema declarations from: " + additionalCSV);
        }
        if (additionalCSV == null) return;
        try {
            additionalCSV.close();
            return;
        }
        catch (IOException e) {
            log.debug("IOException: ", (Throwable)e);
        }
    }

    public static void fillSchemaServiceFromLOV() {
        int count = SchemaService.getSize();
        for (LOVEntry entry : LOVUtils.getAllLOVEntries()) {
            SchemaService.addSchemaDecl(entry.getPrefix(), entry.getVocabularyNamespace(), entry.getVocabularyDefinedBy());
        }
        count = SchemaService.getSize() - count;
        log.info("Loaded " + count + " additional schema declarations from LOV SPARQL Endpoint");
    }

    public static boolean fileExists(String path) {
        File f = new File(path);
        return f.exists();
    }

    public static <T> T getFirstItemInCollection(Collection<T> collection) {
        Iterator<T> iterator = collection.iterator();
        if (iterator.hasNext()) {
            T item = iterator.next();
            return item;
        }
        return null;
    }
}

