package org.aksw.rdfunit.enums;

import org.aksw.rdfunit.utils.PrefixNSService;

/**
 * <p>TestGenerationType class.</p>
 *
 * @author Dimitris Kontokostas
 *         Describes the test generation methods
 * @since 9/25/13 9:05 AM
 * @version $Id: $Id
 */
public enum TestGenerationType {

    /**
     * AutoGenerated: This test was created automatically
     */
    AutoGenerated,

    /**
     * ManuallyGenerated: This test was created manually
     */
    ManuallyGenerated;

    /**
     * Holds the prefix to resolve this enum
     */
    private static final String schemaPrefix = "rut";

    /**
     * <p>getUri.</p>
     *
     * @return a full URI/IRI as a String
     */
    public String getUri() {
        return PrefixNSService.getNSFromPrefix(schemaPrefix) + name();
    }

    /** {@inheritDoc} */
    @Override
    public String toString() {
        return getUri();
    }

    /**
     * Resolves a full URI/IRI to an enum
     *
     * @param value the URI/IRI we want to resolve
     * @return the equivalent enum type or null if it cannot resolve
     */
    public static TestGenerationType resolve(String value) {

        String qName = PrefixNSService.getLocalName(value, schemaPrefix);
        for (TestGenerationType type : values()) {
            if (qName.equals(type.name())) {
                return type;
            }
        }
        return null;
    }
}
